/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.address.client;

import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.address.client.dto.StreetDTO;
import java.util.Comparator;

public class FullAddressComparator
implements Comparator<AddressDTO> {
    @Override
    public int compare(AddressDTO o1, AddressDTO o2) {
        try {
            if (o1.getCityId() == null) {
                return o2.getCityId() == null ? 0 : 1;
            }
            if (o2.getCityId() == null) {
                return -1;
            }
            if (o1.getStreetId() == null) {
                if (o2.getStreetId() == null) {
                    return this.compareAddressByBlock(o1, o2);
                }
                return -1;
            }
            if (o2.getStreetId() == null) {
                return 1;
            }
            if (o1.getStreetId().equals(o2.getStreetId())) {
                int res = StringUtil.compareNumbers(o1.getStreetNo(), o2.getStreetNo());
                if (res == 0) {
                    return this.compareAddressByBlock(o1, o2);
                }
                return res;
            }
            StreetDTO street1 = o1.getStreetDto();
            StreetDTO street2 = o2.getStreetDto();
            if (street1 != null && street2 != null) {
                if (street1.getName() != null) {
                    return street1.getName().compareTo(street2.getName());
                }
                return -1;
            }
            if (street1 != null) {
                return 1;
            }
            return -1;
        }
        catch (DTOFindException ex) {
            throw new Error(ex);
        }
    }

    private int compareAddressByBlock(AddressDTO a1, AddressDTO a2) {
        int res = StringUtil.compareNumbers(a1.getBlockNumber(), a2.getBlockNumber());
        if (res != 0) {
            return res;
        }
        res = StringUtil.compareNumbers(a1.getEntranceNo(), a2.getEntranceNo());
        if (res != 0) {
            return res;
        }
        res = StringUtil.compareNumbers(a1.getFloor(), a2.getFloor());
        if (res != 0) {
            return res;
        }
        return StringUtil.compareNumbers(a1.getRoomNumber(), a2.getRoomNumber());
    }
}

