/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.address.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.address.client.dto.CityDTO;
import com.dsoft.powerpro.address.client.dto.StreetDTO;

@ServerLoader(value="PowerPro/AddressLoader/local")
public class AddressDTO
extends HistoryDTO {
    private String poBox;
    private String blockNumber;
    private String floor;
    private String roomNumber;
    private String postalCode;
    private String entranceNo;
    private String streetNo;
    private String district;
    private String strAddress;
    private static final String StreetDto = "StreetDto";
    private static final String CityDto = "CityDto";

    public AddressDTO() {
        this.registerProperty(StreetDTO.class, StreetDto, false);
        this.registerProperty(CityDTO.class, CityDto, false);
    }

    public void setBlockNumber(String str) {
        this.setModified(this.blockNumber, str, "blockNumber");
        this.blockNumber = str;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setFloor(String floor) {
        this.setModified(this.floor, floor, "floor");
        this.floor = floor;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setRoomNumber(String room) {
        this.setModified(this.roomNumber, room, "rootNumber");
        this.roomNumber = room;
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public void setPostalCode(String str) {
        this.setModified(this.postalCode, str, "postalCode");
        this.postalCode = str;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setEntranceNo(String str) {
        this.setModified(this.entranceNo, str, "entranceNo");
        this.entranceNo = str;
    }

    public String getEntranceNo() {
        return this.entranceNo;
    }

    public void setStreetNo(String str) {
        this.setModified(this.streetNo, str, "streetNo");
        this.streetNo = str;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public void setDistrict(String district) {
        this.setModified(this.district, district, "district");
        this.district = district;
    }

    public void setStrAddress(String strAddress) {
        this.setModified(this.strAddress, strAddress, "strAddress");
        this.strAddress = strAddress;
    }

    public void setPoBox(String poBox) {
        this.setModified(this.poBox, poBox, "poBox");
        this.poBox = poBox;
    }

    public void setStreetId(Integer streetId) {
        this.putObjectValue(StreetDto, streetId);
    }

    public void setCityId(Integer cityId) {
        this.putObjectValue(CityDto, cityId);
    }

    public String getDistrict() {
        return this.district;
    }

    public String getStrAddress() {
        return this.strAddress;
    }

    public String getPoBox() {
        return this.poBox;
    }

    public Integer getStreetId() {
        return (Integer)this.getObjectValue(StreetDto);
    }

    public Integer getCityId() {
        return (Integer)this.getObjectValue(CityDto);
    }

    public CityDTO getCityDto() throws DTOFindException {
        return (CityDTO)this.getPropertyValue(CityDto);
    }

    public StreetDTO getStreetDto() throws DTOFindException {
        return (StreetDTO)this.getPropertyValue(StreetDto);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result) {
            AddressDTO that = (AddressDTO)obj;
            if (!(that.blockNumber != null ? that.blockNumber.equals(this.blockNumber) : this.blockNumber == null)) {
                return false;
            }
            if (!(that.getCityId() != null ? that.getCityId().equals(this.getCityId()) : this.getCityId() == null)) {
                return false;
            }
            if (!(that.district != null ? that.district.equals(this.district) : this.district == null)) {
                return false;
            }
            if (!(that.entranceNo != null ? that.entranceNo.equals(this.entranceNo) : this.entranceNo == null)) {
                return false;
            }
            if (!(that.floor != null ? that.floor.equals(this.floor) : this.floor == null)) {
                return false;
            }
            if (!(that.poBox != null ? that.poBox.equals(this.poBox) : this.poBox == null)) {
                return false;
            }
            if (!(that.postalCode != null ? that.postalCode.equals(this.postalCode) : this.postalCode == null)) {
                return false;
            }
            if (!(that.roomNumber != null ? that.roomNumber.equals(this.roomNumber) : this.roomNumber == null)) {
                return false;
            }
            if (!(that.strAddress != null ? that.strAddress.equals(this.strAddress) : this.strAddress == null)) {
                return false;
            }
            if (!(that.getStreetId() != null ? that.getStreetId().equals(this.getStreetId()) : this.getStreetId() == null)) {
                return false;
            }
            if (!(that.streetNo != null ? that.streetNo.equals(this.streetNo) : this.streetNo == null)) {
                return false;
            }
        }
        return result;
    }

    public boolean isSameAddress(AddressDTO address) {
        if (address == null) {
            return false;
        }
        if (this.getId().equals(address.getId())) {
            return true;
        }
        if (this.getCityId() != null && !this.getCityId().equals(address.getCityId())) {
            return false;
        }
        if (!(StringUtil.isEmpty(this.getBlockNumber()) && StringUtil.isEmpty(address.getBlockNumber()) || this.getBlockNumber() != null && this.getBlockNumber().equals(address.getBlockNumber()))) {
            return false;
        }
        if (!(this.getStreetId() == null && address.getStreetId() == null || this.getStreetId() != null && this.getStreetId().equals(address.getStreetId()))) {
            return false;
        }
        if (!(StringUtil.isEmpty(this.getStreetNo()) && StringUtil.isEmpty(address.getStreetNo()) || this.getStreetNo() != null && this.getStreetNo().equals(address.getStreetNo()))) {
            return false;
        }
        if (!(StringUtil.isEmpty(this.getEntranceNo()) && StringUtil.isEmpty(address.getEntranceNo()) || this.getEntranceNo() != null && this.getEntranceNo().equals(address.getEntranceNo()))) {
            return false;
        }
        if (!(StringUtil.isEmpty(this.getFloor()) && StringUtil.isEmpty(address.getFloor()) || this.getFloor() != null && this.getFloor().equals(address.getFloor()))) {
            return false;
        }
        return StringUtil.isEmpty(this.getRoomNumber()) && StringUtil.isEmpty(address.getRoomNumber()) || this.getRoomNumber() != null && this.getRoomNumber().equals(address.getRoomNumber());
    }
}

