/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.address.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.base.NamedItem;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.address.client.Messages;
import com.dsoft.powerpro.address.client.dto.CountryDto;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

@ServerLoader(value="PowerPro/RegionLoader/local")
public class RegionDTO
extends IntegerIdDTO
implements Comparable<RegionDTO>,
NamedItem<Integer> {
    private static final String NAME = "name";
    private static final String COUNTRY = "country";
    private String name;
    private String description;

    public RegionDTO() {
        this.registerProperty(CountryDto.class, COUNTRY, false);
    }

    public void setName(String str) throws PropertyVetoException {
        if (StringUtil.isEmpty(str)) {
            throw new PropertyVetoException(Messages.getString("RegionDTO.2"), new PropertyChangeEvent(this, NAME, this.name, str));
        }
        this.setModified(this.name, str, NAME);
        this.name = str;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String str) {
        this.setModified(this.description, str, "description");
        this.description = str;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public CountryDto getCountry() throws DTOFindException {
        return (CountryDto)this.getPropertyValue(COUNTRY);
    }

    public void setCountryId(Integer countryId) {
        this.putObjectValue(COUNTRY, countryId);
    }

    public Integer getCountryId() {
        return (Integer)this.getObjectValue(COUNTRY);
    }

    @Override
    public int compareTo(RegionDTO regionDto) {
        int result;
        try {
            result = this.getCountryId() != null ? this.getCountry().compareTo(regionDto.getCountry()) : 0;
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
        if (result == 0) {
            result = this.name.compareTo(regionDto.name);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

