/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.address.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.NamedItem;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.Messages;
import com.dsoft.powerpro.address.client.dto.CityDTO;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

@ServerLoader(value="PowerPro/StreetLoader/local")
public class StreetDTO
extends HistoryDTO
implements Comparable<StreetDTO>,
NamedItem<Integer> {
    private static final String NAME2 = "name";
    private String name;
    private String description;
    private String streetType;
    private static final String CityDto = "CityDto";

    public StreetDTO() {
        this.registerProperty(CityDTO.class, CityDto, false);
    }

    public void setName(String str) throws PropertyVetoException {
        if (str == null || str.trim().length() == 0) {
            throw new PropertyVetoException(Messages.getString("StreetDTO.0"), new PropertyChangeEvent(this, NAME2, this.name, str));
        }
        this.setModified(this.name, str, NAME2);
        this.name = str;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String str) {
        this.setModified(this.description, str, "description");
        this.description = str;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public CityDTO getCity() throws DTOFindException {
        return (CityDTO)this.getPropertyValue(CityDto);
    }

    public void setStreetType(String type) {
        this.setModified(this.streetType, type, "streetType");
        this.streetType = type;
    }

    public void setCityId(Integer cityId) {
        this.putObjectValue(CityDto, cityId);
    }

    public String getStreetType() {
        return this.streetType;
    }

    public Integer getCityId() {
        return (Integer)this.getObjectValue(CityDto);
    }

    @Override
    public int compareTo(StreetDTO street) {
        int result;
        try {
            result = this.getCity().compareTo(street.getCity());
        }
        catch (DTOFindException ex) {
            throw new RuntimeException(ex);
        }
        if (result == 0) {
            result = this.name.compareTo(street.name);
        }
        if (result == 0) {
            result = this.streetType.compareTo(street.streetType);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.streetType + ", " + this.name;
    }
}

