/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent;

import com.dsoft.powerpro.agent.persistence.PersistenceTypeEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picocontainer.annotations.Inject;

public abstract class BaseServerProperties {
    private PersistenceTypeEnum persistenceType;
    private static final ArrayList<String> SHORT_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("-h");
            this.add("-p");
            this.add("-db");
            this.add("-a");
            this.add("-s");
            this.add("-sp");
            this.add("-l");
            this.add("-ps");
        }
    };
    private static final ArrayList<String> LONG_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("--help");
            this.add("--syslog-port");
            this.add("--database-directory");
            this.add("--agent-id");
            this.add("--server");
            this.add("--server-port");
            this.add("--log");
            this.add("--persistence");
        }
    };
    private HashMap<BaseOptions, String> propertiesMap = new HashMap();
    private int syslogPort;
    private String dbDirectory;
    private int serverPort = 8192;
    private Map<String, String> logLevelsMap = new HashMap<String, String>();

    public BaseServerProperties() {
        this.propertiesMap.put(BaseOptions.DATABASE_PATH, "/var/db/powerpro");
        this.propertiesMap.put(BaseOptions.SYSLOG_PORT, "10514");
        this.propertiesMap.put(BaseOptions.SERVER_PORT, "8192");
        this.propertiesMap.put(BaseOptions.LOG, Level.WARNING.getName());
        this.propertiesMap.put(BaseOptions.PERSISTENCE, PersistenceTypeEnum.NO_SQL.name());
    }

    protected abstract void displayProductName();

    protected void displayUsageOptions() {
        System.out.println("Usage: cmd [options]");
        System.out.println("  -h --help                Display this message");
        System.out.println("  -p x --syslog-port=x            Set syslog tcp listener port to x. Default is 10514");
        System.out.println("  -db dir " + System.getProperty("line.separator"));
        System.out.println("  --database-directory=dir Set database directory to <dir>. This is where program stores all local database information. Default is /var/db/powerpro");
        System.out.println("  -a agentId");
        System.out.println("  --agent-id=agentId        Provide agent identifier. It is used to authorize agent with monitoring aggregator");
        System.out.println("  -s server");
        System.out.println("  --server=server           Provides ip address or host name of the monitoring aggregator");
        System.out.println("  -sp port");
        System.out.println("  --server-port=port        Provides tcp port for communication with monitoring aggregator. Default is 8192.");
        System.out.println("  -ps persistence");
        System.out.println("  --persistence=persistence Specifies persistence mechanism used by agent to store it's data. Default is NO_SQL. Other possible values are FILE and SQL.");
        System.out.println("  -l logger,log_level");
        System.out.println("  --log=logger,log_level    Specifies console log level for logger. Default is INFO. Possible values are ALL, FINEST, FINE, INFO, WARNING, SEVERE");
    }

    public String getAgentIdentifier() {
        return this.propertiesMap.get((Object)BaseOptions.AGENT_ID);
    }

    public String getDbDirectory() {
        return this.dbDirectory;
    }

    public String getLogLevel() {
        return this.propertiesMap.get((Object)BaseOptions.LOG);
    }

    public String getServerAddress() {
        return this.propertiesMap.get((Object)BaseOptions.SERVER_ADDRESS);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getSyslogPort() {
        return this.syslogPort;
    }

    public PersistenceTypeEnum getPersistenceType() {
        return this.persistenceType;
    }

    private void initializePrivate(String[] args) throws Exception {
        int param = -1;
        String paramName = null;
        for (String arg : args) {
            if (param == -1 && paramName == null) {
                if (arg.startsWith("--")) {
                    if (arg.indexOf("=") > 0) {
                        paramName = arg.substring(0, arg.indexOf("="));
                        param = this.recognizeLongOption(paramName);
                        arg = arg.substring(arg.indexOf("=") + 1);
                    } else {
                        this.invalidOption(arg);
                    }
                } else {
                    param = this.recognizeShortOption(arg);
                    paramName = arg;
                    continue;
                }
            }
            if (param >= 0) {
                if (!this.processParam(arg, param)) {
                    this.invalidOption(paramName);
                }
                param = -1;
                paramName = null;
                continue;
            }
            this.invalidOption(paramName);
        }
    }

    private void invalidOption(String paramName) {
        this.showErrorAndExit(String.format("Invalid option %1$s\nUse -h to see all available options.", paramName));
    }

    protected boolean processParam(String arg, int param) throws Exception {
        switch (BaseOptions.values()[param]) {
            case HELP: {
                this.displayUsageOptions();
                System.exit(0);
                break;
            }
            case SYSLOG_PORT: 
            case DATABASE_PATH: 
            case AGENT_ID: 
            case SERVER_ADDRESS: 
            case SERVER_PORT: 
            case PERSISTENCE: {
                this.propertiesMap.put(BaseOptions.values()[param], arg);
                break;
            }
            case LOG: {
                if (arg.indexOf(",") > 0) {
                    String logger = arg.substring(0, arg.indexOf(","));
                    String level = "INFO";
                    if (arg.indexOf(",") < arg.length() - 1) {
                        level = arg.substring(arg.indexOf(",") + 1);
                    }
                    this.logLevelsMap.put(logger, level);
                    break;
                }
                this.propertiesMap.put(BaseOptions.values()[param], arg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected int recognizeLongOption(String paramName) {
        return LONG_OPTIONS.indexOf(paramName);
    }

    protected int recognizeShortOption(String paramName) {
        return SHORT_OPTIONS.indexOf(paramName);
    }

    @Inject
    public void setArgs(String[] args) {
        try {
            this.initializePrivate(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected void showErrorAndExit(String errorMessage) {
        System.err.println(errorMessage);
        this.displayUsageOptions();
        System.exit(-1);
    }

    protected void verifyOptionValues() {
        this.dbDirectory = this.propertiesMap.get((Object)BaseOptions.DATABASE_PATH);
        File dir = new File(this.dbDirectory);
        if (!dir.exists()) {
            this.showErrorAndExit(String.format("Directory %1$s does not exists!", this.dbDirectory));
        }
        if (!dir.isDirectory()) {
            this.showErrorAndExit(String.format("Provided database path %1$s is not directory!", this.dbDirectory));
        }
        try {
            String tmpFileName = dir.getPath() + System.getProperty("file.separator") + "testFile.tmp";
            new FileOutputStream(tmpFileName).close();
            new File(tmpFileName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            this.syslogPort = Integer.parseInt(this.propertiesMap.get((Object)BaseOptions.SYSLOG_PORT));
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid syslog port number(%1$s)!", this.propertiesMap.get((Object)BaseOptions.SYSLOG_PORT)));
        }
        try {
            this.serverPort = Integer.parseInt(this.propertiesMap.get((Object)BaseOptions.SERVER_PORT));
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid server port number(%1$s)!", this.propertiesMap.get((Object)BaseOptions.SERVER_PORT)));
        }
        if (this.propertiesMap.containsKey((Object)BaseOptions.LOG) && Level.parse(this.propertiesMap.get((Object)BaseOptions.LOG)) == null) {
            this.showErrorAndExit("Invalid value for log level!");
        }
        try {
            this.persistenceType = PersistenceTypeEnum.valueOf(this.propertiesMap.get((Object)BaseOptions.PERSISTENCE));
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid persistence type specified(%1$s)!", this.propertiesMap.get((Object)BaseOptions.PERSISTENCE)));
        }
        Logger.getLogger("com.dsoft").setLevel(Level.parse(this.getLogLevel()));
        for (String logger : this.logLevelsMap.keySet()) {
            Logger.getLogger(logger).setLevel(Level.parse(this.logLevelsMap.get(logger)));
        }
        if (!this.propertiesMap.containsKey((Object)BaseOptions.AGENT_ID)) {
            this.showErrorAndExit("Missing or invalid agent identifier!");
        }
        if (!this.propertiesMap.containsKey((Object)BaseOptions.SERVER_ADDRESS)) {
            this.showErrorAndExit("Missing or invalid server address!");
        }
    }

    static enum BaseOptions {
        HELP,
        SYSLOG_PORT,
        DATABASE_PATH,
        AGENT_ID,
        SERVER_ADDRESS,
        SERVER_PORT,
        LOG,
        PERSISTENCE;

    }
}

