/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageListener;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class MessageDistributorImpl
implements MessageDistributor,
Runnable {
    private static final Logger logger = Logger.getLogger(MessageDistributorImpl.class.getName());
    private MessagingAgent agent;
    private static final Map<Class<?>, List<MessageListener>> messageListenersMap = new HashMap();
    private Thread agentThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(Class<?> messageClass, MessageListener listener) {
        Map<Class<?>, List<MessageListener>> map = messageListenersMap;
        synchronized (map) {
            List<MessageListener> messageListeners;
            do {
                if ((messageListeners = messageListenersMap.get(messageClass)) != null) continue;
                messageListenersMap.put(messageClass, new ArrayList());
            } while (messageListeners == null);
            messageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeMessages(List<Object> messagesList) {
        Map<Class<?>, List<MessageListener>> map = messageListenersMap;
        synchronized (map) {
            for (List<MessageListener> list : messageListenersMap.values()) {
                for (MessageListener messageListener : list) {
                    messageListener.beginProcessing();
                }
            }
            for (Object object : messagesList) {
                for (Class clazz : messageListenersMap.keySet()) {
                    if (!clazz.isAssignableFrom(object.getClass())) continue;
                    List<MessageListener> messageListeners = messageListenersMap.get(clazz);
                    for (MessageListener listener : messageListeners) {
                        try {
                            listener.processMessage(object);
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, String.format("Error while processing message of type %1$s", object.getClass().getSimpleName()), e);
                        }
                    }
                }
            }
            for (List list : messageListenersMap.values()) {
                for (MessageListener messageListener : list) {
                    messageListener.endProcessing();
                }
            }
        }
    }

    @Override
    public void run() {
        ArrayList<Object> messagesList = new ArrayList<Object>();
        while (!Thread.currentThread().isInterrupted()) {
            messagesList.clear();
            Object message = null;
            do {
                block10: {
                    if (this.agent.getReaderThread() != null) {
                        try {
                            message = this.agent.getReaderThread().peek(100L);
                            break block10;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (message instanceof String) {
                    String messageStr = (String)message;
                    if (messageStr.equalsIgnoreCase("PAUSE")) {
                        this.agent.pause();
                    }
                    if (!messageStr.equalsIgnoreCase("RESUME")) continue;
                    this.agent.resume();
                    continue;
                }
                if (message == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Message of type %1$s has been received", message.getClass().getSimpleName()));
                }
                messagesList.add(message);
            } while (message != null && messagesList.size() < 50);
            if (messagesList.isEmpty()) continue;
            this.distributeMessages(messagesList);
        }
    }

    @Inject
    public void setMessagingAgent(MessagingAgent agent) {
        this.agent = agent;
    }

    @Inject
    public void setThreadGroup(ThreadGroup threadGroup) {
        this.agentThread = new Thread(threadGroup, this, "Message distribution thread");
    }

    @PostConstruct
    public void start() {
        this.agentThread.start();
    }

    @PreDestroy
    public void stop() {
        this.agentThread.interrupt();
    }
}

