/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.messaging.ConnectionListener;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import com.dsoft.powerpro.agent.messaging.ReaderThread;
import com.dsoft.powerpro.agent.messaging.WriterThread;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.SocketFactory;
import org.picocontainer.annotations.Inject;

public class MonitoringAgent
implements MessagingAgent,
Runnable {
    private static final Logger logger = Logger.getLogger(MonitoringAgent.class.getName());
    private static final int HUNDRED_MS = 100;
    private static final int TEN_SECONDS = 10000;
    private WriterThread writerThread;
    private ReaderThread readerThread;
    @Inject
    private MessageQueue messageQueue;
    private final Object rwLock = new Object();
    private String serverAddress = "localhost";
    private int port = 29999;
    private String agentIdentifier = "default";
    private Socket socket;
    private Thread agentThread;
    private List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    @Inject
    private BaseServerProperties properties;
    @Inject
    private ThreadGroup threadGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject("TEST STRING OBJECT");
            oos.close();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        MonitoringAgent ma = new MonitoringAgent();
        ma.threadGroup = new ThreadGroup("Monitoring agent thread group");
        ma.properties = new BaseServerProperties(){

            @Override
            protected void displayProductName() {
            }
        };
        ma.messageQueue = new MessageQueue(){
            {
                this.initializeQueue();
            }

            @Override
            protected MessageQueue.PersistenceTask getLoadJob(final QueueObject result) {
                return new MessageQueue.PersistenceTask(){

                    @Override
                    public void run() throws Exception {
                        result.setSerializedObject(baos.toByteArray());
                    }
                };
            }

            @Override
            protected MessageQueue.PersistenceTask getDeleteJob(Long messageId) {
                return new MessageQueue.PersistenceTask(){

                    @Override
                    public void run() throws Exception {
                    }
                };
            }

            @Override
            protected MessageQueue.PersistenceTask getInsertJob(QueueObject queueObject) {
                return new MessageQueue.PersistenceTask(){

                    @Override
                    public void run() throws Exception {
                    }
                };
            }
        };
        ma.start();
        MonitoringAgent monitoringAgent = ma;
        synchronized (monitoringAgent) {
            ma.wait(3000L);
        }
        for (int i = 0; i < 200000; ++i) {
            try {
                ma.messageQueue.postMessage("TEST MESSAGE aasfas;dljf;asdlkf;asldkf';asdlkf';asdlkfas;dlfkas';dlkf'asd;lkfasd';lkfasd;lfkasd;'lkfas';lfk;a'slkfa's;dlkf;a'slkf;'lasdkf;'lasdkf;'alsdkf;'aslkf;'asldkf';alsdkf';alsdkf';asldkf';asldkf';alsdkf;'alsdkf;'lasdkf';alsdkf;'lasdkf;'adlskf;laskdf;'lasdkf;'lasdkf;lasdkf';asdlkf;'aslkdf;'alsdkf;'laskdf';laskdf;'lsadkf;lkasdfpoqwierpoiqwer[poiqwep[roiwqe[proiqwe[proiqwep[oriqwep[oriqwp[]eoi;odlkdfsjgl;ksdfjg;ldsfkjg;ldfskj;glkjwoeirt8uweroiutpowierutopiewrutoiwerutew[irout[erijhgs'kdjgsdkfjg;ldsfkjglsdfkjg;lsdfkjg;lksdfjioewurt[oiwerut[erut[pweroit[powerit[poweir[tpoewiutp[oweirt[poewrit[poeilkdsfjg;lskdfjgl;dkjgs;lkjsdf;lksdjg;lkjgsd'kjgds'lkfjg'sdfkljglkdsfjg;lkdsjfg;lsdkfjl;ksdgfjs;dlkjg;sldfkgjsld;fkgjsd;lkjgd;slkj" + i, 0, 10000L, 0, false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("All messages posted");
    }

    @PostConstruct
    public void start() {
        try {
            this.agentThread = new Thread(this.threadGroup, this, "Monitoring Agent main thread");
            this.initializeParameters(this.properties);
            this.agentThread.start();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void pause() {
        if (this.writerThread != null) {
            this.writerThread.pause();
        }
    }

    @Override
    public void resume() {
        if (this.writerThread != null) {
            this.writerThread.restore();
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReaderThread getReaderThread() {
        Object object = this.rwLock;
        synchronized (object) {
            return this.readerThread;
        }
    }

    private void initializeParameters(BaseServerProperties properties) throws UnknownHostException {
        String lagetnIdentifier = properties.getAgentIdentifier();
        String lserverAddress = properties.getServerAddress();
        if (!StringUtil.isEmpty(lagetnIdentifier)) {
            this.setAgentIdentifier(lagetnIdentifier);
        }
        if (!StringUtil.isEmpty(lserverAddress)) {
            this.setServerAddress(lserverAddress);
        }
        this.setPort(properties.getServerPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Iterator<ConnectionListener> iterator = this.rwLock;
                synchronized (iterator) {
                    this.readerThread = null;
                    this.writerThread = null;
                }
                while (!this.tryConnect()) {
                    Thread.sleep(10000L);
                }
                Thread.sleep(100L);
                if (i != 0) {
                    for (ConnectionListener listener : this.listeners) {
                        listener.connectionReestablished();
                    }
                }
                ++i;
                while (this.writerThread.isAlive() && this.readerThread.isAlive()) {
                    Thread.sleep(100L);
                }
                if (this.readerThread.isAlive()) {
                    this.readerThread.interrupt();
                }
                if (this.writerThread.isAlive()) {
                    this.writerThread.interrupt();
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (ConnectionListener listener : this.listeners) {
                    listener.connectionLost();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void setAgentIdentifier(String agentIdentifier) {
        this.agentIdentifier = agentIdentifier;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @PreDestroy
    public void stop() {
        this.agentThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryConnect() throws InterruptedException {
        try {
            this.socket = SocketFactory.getDefault().createSocket(this.serverAddress, this.port);
        }
        catch (IOException ce) {
            return false;
        }
        try {
            this.socket.setSoTimeout(10000);
            ReaderThread readerThread = new ReaderThread(this.socket.getInputStream());
            WriterThread writerThread = new WriterThread(this.socket.getOutputStream(), readerThread, this.agentIdentifier, this.messageQueue);
            Object object = this.rwLock;
            synchronized (object) {
                this.readerThread = readerThread;
                this.writerThread = writerThread;
            }
            return true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }
}

