/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.powerpro.agent.messaging.ReaderThread;
import com.dsoft.powerpro.internet.mserver.queue.BaseThread;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriterThread
extends BaseThread {
    private static final Logger LOGGER = Logger.getLogger(WriterThread.class.getName());
    private static final String UTF_8 = "utf-8";
    private static final long TEN_SECONDS = 10000L;
    private static final TreeSet<QueueObject> EMPTY_SET = new TreeSet();
    private MessageQueue messageQueue;
    private boolean paused = false;

    WriterThread(OutputStream outputStream, ReaderThread readerThread, String agentIdentifier, MessageQueue messageQueue) throws IOException, InterruptedException {
        super("Writer thread", outputStream);
        this.messageQueue = messageQueue;
        this.writeData(agentIdentifier.getBytes(UTF_8), true, false);
        Object response = readerThread.peek(10000L);
        if (response != null) {
            if (response instanceof String && response.equals("OK")) {
                this.start();
            } else {
                this.interrupt();
            }
        } else {
            this.interrupt();
        }
    }

    private void returnMessagesToQueue(Collection<QueueObject> messages) {
        for (QueueObject object : messages) {
            this.messageQueue.returnBackToQueue(object, null);
        }
    }

    @Override
    public void run() {
        try {
            long lastWrite = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                lastWrite = this.checkWriteQueue(lastWrite);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.info("Writer thread has been interrupted! Exiting writer thread.");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private long checkWriteQueue(long lastWrite) throws Exception {
        TreeSet<QueueObject> messages = EMPTY_SET;
        if (this.paused) {
            while (this.paused) {
                lastWrite = this.ping(lastWrite);
                messages = new TreeSet<QueueObject>(this.messageQueue.popHighPriorityMessages(null));
                if (messages.isEmpty()) continue;
                break;
            }
        } else {
            messages = new TreeSet<QueueObject>(this.messageQueue.popMessages(null, 5));
        }
        if (messages.isEmpty()) {
            lastWrite = this.ping(lastWrite);
        } else {
            this.writeMessages(messages);
            lastWrite = System.currentTimeMillis();
        }
        return lastWrite;
    }

    private long ping(long lastWrite) throws IOException, InterruptedException {
        if (System.currentTimeMillis() - lastWrite > 10000L) {
            this.writeData("PING".getBytes(UTF_8), true, false);
            lastWrite = System.currentTimeMillis();
        }
        Thread.sleep(100L);
        return lastWrite;
    }

    private void writeMessages(TreeSet<QueueObject> messages) throws Exception {
        block4: while (!messages.isEmpty()) {
            Iterator<QueueObject> it = messages.iterator();
            while (it.hasNext()) {
                TreeSet<QueueObject> highPriorityMessages;
                QueueObject object = it.next();
                if (object.getPriority() == 0 && !(highPriorityMessages = new TreeSet<QueueObject>(this.messageQueue.popHighPriorityMessages(null))).isEmpty()) {
                    highPriorityMessages.addAll(messages);
                    messages = highPriorityMessages;
                    continue block4;
                }
                try {
                    this.writeData(object.getSerializedObject(), false, it.hasNext());
                }
                catch (IOException e) {
                    this.returnMessagesToQueue(messages);
                    throw e;
                }
                try {
                    this.messageQueue.confirmMessage(object.getId());
                    it.remove();
                }
                catch (Exception e) {
                    this.returnMessagesToQueue(messages);
                    throw e;
                }
            }
        }
    }

    public void pause() {
        LOGGER.log(Level.INFO, "Pausing packet transmissions");
        this.paused = true;
    }

    public void restore() {
        LOGGER.log(Level.INFO, "Restoring packet transmissions");
        this.paused = false;
    }
}

