/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.persistence;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.persistence.Entity;
import com.dsoft.powerpro.agent.persistence.FinderException;
import com.dsoft.powerpro.agent.persistence.FinderExpression;
import com.dsoft.powerpro.agent.persistence.PersistenceAdapter;
import com.dsoft.powerpro.agent.persistence.PersistenceException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePersistence
extends PersistenceAdapter {
    private static final Logger LOGGER = Logger.getLogger(FilePersistence.class.getName());
    int loading = 0;

    public FilePersistence(BaseServerProperties serverProperties) {
        super(serverProperties);
    }

    @Override
    public <E extends Entity<?, ?>> E persist(E entity) throws PersistenceException {
        entity = super.persist(entity);
        try {
            this.writeEntity(entity);
        }
        catch (IOException ex) {
            throw new PersistenceException("Error while storing entity on persistence storage", ex);
        }
        return entity;
    }

    @Override
    public <E extends Entity<E, ?>> Collection<E> findAll(Class<E> entityClass) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        return super.findAll(entityClass);
    }

    private boolean checkForLoading() {
        try {
            while (this.loading > 0) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ex1) {
            return false;
        }
        return true;
    }

    @Override
    public <E extends Entity<E, ?>> E find(Class<E> entityClass, Object primaryKey) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        return super.find(entityClass, primaryKey);
    }

    @Override
    public <E extends Entity<E, ?>> Collection<E> findEntities(Class<E> entityClass, FinderExpression<E> expression) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        return super.findEntities(entityClass, expression);
    }

    private String getTableFileNamePrefix(String tableName) {
        return this.getDatabaseDirectoryName() + System.getProperty("file.separator") + tableName + "_";
    }

    private void loadEntities(final String tableName) throws IOException {
        final File dbDirectory = new File(this.getDatabaseDirectoryName());
        if (dbDirectory.exists()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, String.format("Loading entities for table %1$s", tableName));
                    }
                    ++FilePersistence.this.loading;
                    try {
                        File[] dbFiles;
                        for (File leaseFile : dbFiles = dbDirectory.listFiles()) {
                            if (!leaseFile.getName().startsWith(tableName) || !leaseFile.getName().endsWith(".xml")) continue;
                            Entity entity = null;
                            try {
                                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(leaseFile));
                                try {
                                    XMLDecoder decoder = new XMLDecoder(fis);
                                    try {
                                        entity = (Entity)decoder.readObject();
                                    }
                                    finally {
                                        decoder.close();
                                    }
                                }
                                finally {
                                    ((InputStream)fis).close();
                                }
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, String.format("Error while reading entity %1$s", leaseFile.getName()), ex);
                            }
                            if (entity == null) continue;
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, String.format("Loading entity for table %1$s and primary key %2$s", tableName, entity.primaryKey().toString()));
                            }
                            FilePersistence.this.registerEntity(entity);
                        }
                    }
                    finally {
                        --FilePersistence.this.loading;
                    }
                }
            }.start();
        } else {
            dbDirectory.mkdirs();
        }
    }

    @Override
    public <E extends Entity<E, ?>> void registerTable(String tableName, Class<E> tableClass) throws PersistenceException {
        super.registerTable(tableName, tableClass);
        try {
            this.loadEntities(tableName);
        }
        catch (IOException ex) {
            throw new PersistenceException("Error while loading data from persistence storage", ex);
        }
    }

    @Override
    public void removeEntity(Entity<?, ?> entity) throws PersistenceException {
        super.removeEntity(entity);
        String fileName = this.getTableFileNamePrefix(this.getTablesMap().get(entity.getClass())) + entity.primaryKey().toString().toUpperCase() + ".xml";
        File entityFile = new File(fileName);
        entityFile.delete();
    }

    @Override
    public <E extends Entity<?, ?>> E merge(E entity) throws PersistenceException {
        entity = super.merge(entity);
        try {
            this.writeEntity(entity);
        }
        catch (IOException ex) {
            throw new PersistenceException("Error while updating entity on persistence storage", ex);
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntity(Entity<?, ?> entity) throws IOException {
        String fileName = this.getTableFileNamePrefix(this.getTablesMap().get(entity.getClass())) + entity.primaryKey().toString().toUpperCase() + ".xml";
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            XMLEncoder xmlEncoder = new XMLEncoder(fos);
            try {
                xmlEncoder.writeObject(entity);
                xmlEncoder.flush();
            }
            finally {
                xmlEncoder.close();
                fos.flush();
            }
        }
        finally {
            fos.close();
        }
    }
}

