/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.persistence;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.persistence.Entity;
import com.dsoft.powerpro.agent.persistence.PersistenceAdapter;
import com.dsoft.powerpro.agent.persistence.PersistenceException;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;

public class NoSQLDatabasePersistence
extends PersistenceAdapter {
    private Map<DatabaseHash, Long> lastUsed = new HashMap<DatabaseHash, Long>();
    private ThreadLocalDatabase db = new ThreadLocalDatabase();

    public NoSQLDatabasePersistence(BaseServerProperties serverProperties) {
        super(serverProperties);
    }

    @PostConstruct
    public void initializeDtabase() {
    }

    @Override
    public <E extends Entity<?, ?>> E persist(E entity) throws PersistenceException {
        entity = (Entity)this.db.get().save(entity);
        return super.persist(entity);
    }

    @Override
    public <E extends Entity<E, ?>> void registerTable(String tableName, Class<E> tableClass) throws PersistenceException {
        super.registerTable(tableName, tableClass);
        this.db.get().getEntityManager().registerEntityClass(tableClass);
        Object entities = this.db.get().query(new OSQLSynchQuery(String.format("select * from %1$s", tableClass.getSimpleName())), new Object[0]);
        for (Entity entity : entities) {
            this.registerEntity(entity);
        }
    }

    @Override
    public void removeEntity(Entity<?, ?> entity) throws PersistenceException {
        super.removeEntity(entity);
        this.db.get().delete(entity);
    }

    @Override
    public <E extends Entity<?, ?>> E merge(E entity) throws PersistenceException {
        if (!entity.getClass().getSimpleName().contains("javassist")) {
            Object dbEntity = this.find(entity.getClass(), entity.primaryKey());
            dbEntity.updateFields(entity);
            entity = dbEntity;
        }
        entity = (Entity)this.db.get().save(entity);
        return super.merge(entity);
    }

    class ThreadLocalDatabase
    extends ThreadLocal<OObjectDatabaseTx> {
        ThreadLocalDatabase() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ThreadLocalDatabase threadLocalDatabase = ThreadLocalDatabase.this;
                    synchronized (threadLocalDatabase) {
                        for (DatabaseHash dbHash : new ArrayList(NoSQLDatabasePersistence.this.lastUsed.keySet())) {
                            dbHash.getDb().close();
                            NoSQLDatabasePersistence.this.lastUsed.remove(dbHash);
                        }
                    }
                }
            });
        }

        @Override
        public OObjectDatabaseTx get() {
            ThreadLocalDatabase threadLocalDatabase = this;
            synchronized (threadLocalDatabase) {
                while (true) {
                    OObjectDatabaseTx db = (OObjectDatabaseTx)super.get();
                    DatabaseHash dbHash = new DatabaseHash(Thread.currentThread(), db);
                    if (NoSQLDatabasePersistence.this.lastUsed.containsKey(dbHash)) {
                        NoSQLDatabasePersistence.this.lastUsed.put(dbHash, System.currentTimeMillis());
                        return db;
                    }
                    this.remove();
                }
            }
        }

        @Override
        protected OObjectDatabaseTx initialValue() {
            String databasePath = NoSQLDatabasePersistence.this.getDatabaseDirectoryName();
            File dbFile = new File(databasePath);
            OObjectDatabaseTx db = !dbFile.exists() ? (OObjectDatabaseTx)new OObjectDatabaseTx("local:" + databasePath).create() : (OObjectDatabaseTx)new OObjectDatabaseTx("local:" + databasePath).open("admin", "admin");
            final DatabaseHash dbHash = new DatabaseHash(Thread.currentThread(), db);
            NoSQLDatabasePersistence.this.lastUsed.put(dbHash, null);
            new Timer(true).schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ThreadLocalDatabase threadLocalDatabase = ThreadLocalDatabase.this;
                    synchronized (threadLocalDatabase) {
                        if (NoSQLDatabasePersistence.this.lastUsed.get(dbHash) != null && System.currentTimeMillis() - (Long)NoSQLDatabasePersistence.this.lastUsed.get(dbHash) > 10000L) {
                            dbHash.getDb().close();
                            NoSQLDatabasePersistence.this.lastUsed.remove(dbHash);
                            this.cancel();
                        }
                    }
                }
            }, 1000L, 5000L);
            return db;
        }
    }

    class DatabaseHash {
        private Thread owner;
        private OObjectDatabaseTx db;

        DatabaseHash(Thread owner, OObjectDatabaseTx db) {
            this.owner = owner;
            this.db = db;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.owner == null ? 0 : this.owner.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DatabaseHash other = (DatabaseHash)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.owner == null ? other.owner != null : !this.owner.getName().equals(other.owner.getName()));
        }

        public OObjectDatabaseTx getDb() {
            return this.db;
        }

        private NoSQLDatabasePersistence getOuterType() {
            return NoSQLDatabasePersistence.this;
        }
    }
}

