/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.persistence;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.persistence.AutoincrementPK;
import com.dsoft.powerpro.agent.persistence.Entity;
import com.dsoft.powerpro.agent.persistence.FinderException;
import com.dsoft.powerpro.agent.persistence.FinderExpression;
import com.dsoft.powerpro.agent.persistence.Persistence;
import com.dsoft.powerpro.agent.persistence.PersistenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PersistenceAdapter
implements Persistence {
    private Map<Class<? extends Entity<?, ?>>, String> tablesMap = new ConcurrentHashMap();
    private final Map<Class<? extends Entity<?, ?>>, Map<Object, ? extends Entity<?, ?>>> entitiesMap = new ConcurrentHashMap();
    private BaseServerProperties serverProperties;
    private Map<Class<? extends Entity<?, ?>>, AutoincrementPK> keyGeneratorsMap = new ConcurrentHashMap();

    public PersistenceAdapter(BaseServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Override
    public Map<Class<? extends Entity<?, ?>>, String> getTablesMap() {
        return this.tablesMap;
    }

    @Override
    public <E extends Entity<?, ?>> E persist(E entity) throws PersistenceException {
        this.checkEntity(entity);
        this.registerEntity(entity);
        return entity;
    }

    @Override
    public <E extends Entity<E, ?>> void registerTable(String tableName, Class<E> tableClass) throws PersistenceException {
        this.tablesMap.put(tableClass, tableName);
    }

    @Override
    public <E extends Entity<E, ?>> void registerTable(String tableName, Class<E> tableClass, AutoincrementPK autoPK) throws PersistenceException {
        this.registerTable(tableName, tableClass);
        if (this.entitiesMap.get(tableClass) != null) {
            autoPK.initializePKGenerator(this.entitiesMap.get(tableClass).keySet().toArray());
        }
        this.keyGeneratorsMap.put(tableClass, autoPK);
    }

    @Override
    public void removeEntity(Entity<?, ?> entity) throws PersistenceException {
        this.checkEntity(entity);
        this.removeEntityFromMap(entity);
    }

    @Override
    public <E extends Entity<?, ?>> E merge(E entity) throws PersistenceException {
        this.checkEntity(entity);
        this.registerEntity(entity);
        return entity;
    }

    private void checkEntity(Entity<?, ?> entity) throws PersistenceException {
        if (entity == null) {
            throw new PersistenceException("entity is null!!");
        }
        if (entity.primaryKey() == null) {
            throw new PersistenceException("Entity primary key is null!!");
        }
        Class<? extends Entity<?, ?>> entityClass = this.getEntityClass(entity);
        if (!this.tablesMap.containsKey(entityClass)) {
            throw new PersistenceException("Unsupported entity class");
        }
    }

    protected Class<? extends Entity<?, ?>> getEntityClass(Entity<?, ?> entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.getSimpleName().contains("javassist")) {
            entityClass = entity.getClass().getSuperclass();
        }
        return entityClass;
    }

    protected String getDatabaseDirectoryName() {
        return this.serverProperties.getDbDirectory() + System.getProperty("file.separator") + "database";
    }

    void registerEntity(Entity<?, ?> entity) {
        Map<Object, Entity<?, ?>> tableMap;
        Class<? extends Entity<?, ?>> entityClass = this.getEntityClass(entity);
        while ((tableMap = this.entitiesMap.get(entityClass)) == null) {
            this.entitiesMap.put(entityClass, new ConcurrentHashMap());
        }
        tableMap.put(entity.primaryKey(), entity);
    }

    private void removeEntityFromMap(Entity<?, ?> entity) {
        Class<? extends Entity<?, ?>> entityClass = this.getEntityClass(entity);
        Map<Object, Entity<?, ?>> tableMap = this.entitiesMap.get(entityClass);
        if (tableMap != null) {
            tableMap.remove(entity.primaryKey());
        }
    }

    @Override
    public <T> T nextPrimaryKey(Class<? extends Entity<?, ?>> tableClass) throws PersistenceException {
        if (this.keyGeneratorsMap.get(tableClass) == null) {
            throw new PersistenceException(String.format("There is no generator for table %1$s", tableClass));
        }
        return (T)this.keyGeneratorsMap.get(tableClass).nextPK();
    }

    @Override
    public <E extends Entity<E, ?>> Collection<E> findAll(Class<E> entityClass) throws FinderException {
        HashMap tableMap = (HashMap)this.entitiesMap.get(entityClass);
        if (tableMap != null) {
            ArrayList<Entity> result = new ArrayList<Entity>();
            try {
                for (Entity entity : new ArrayList(tableMap.values())) {
                    result.add(entity);
                }
            }
            catch (Exception ex) {
                throw new FinderException(ex);
            }
            return result;
        }
        return new ArrayList();
    }

    @Override
    public <E extends Entity<E, ?>> E find(Class<E> entityClass, Object primaryKey) throws FinderException {
        Map<Object, Entity<?, ?>> tableMap = this.entitiesMap.get(entityClass);
        if (tableMap == null) {
            throw new FinderException(String.format("Unable to find entity that matches primary key %1$s", primaryKey.toString()));
        }
        try {
            if (tableMap.containsKey(primaryKey) && tableMap.get(primaryKey) != null) {
                return (E)tableMap.get(primaryKey);
            }
        }
        catch (Exception ex) {
            throw new FinderException(ex);
        }
        throw new FinderException(String.format("Unable to find entity that matches primary key %1$s", primaryKey.toString()));
    }

    @Override
    public <E extends Entity<E, ?>> Collection<E> findEntities(Class<E> entityClass, FinderExpression<E> expression) throws FinderException {
        ArrayList result = new ArrayList();
        Map<Object, Entity<?, ?>> tableMap = this.entitiesMap.get(entityClass);
        if (tableMap == null) {
            return result;
        }
        try {
            for (Entity<?, ?> entity : new ArrayList(tableMap.values())) {
                if (!expression.acceptEntity(entity)) continue;
                result.add(entity);
            }
        }
        catch (Exception ex) {
            throw new FinderException(ex);
        }
        return result;
    }
}

