/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.pool;

import com.dsoft.powerpro.agent.pool.PoolTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool
extends ThreadGroup {
    private static final Logger LOGGER = Logger.getLogger(ThreadPool.class.getName());
    private static int threadPoolID;
    private boolean threadPoolIsAlive;
    private LinkedList<PoolTask> taskQueue;
    private Map<String, PoolTask> threadMap;
    private Set<String> taskSet;
    int threadID = 0;
    private final Timer timer = new Timer(false);

    protected ThreadPool(int numThreads, String threadGroupname) {
        super(threadGroupname + "-" + threadPoolID++);
        this.setDaemon(true);
        this.threadPoolIsAlive = true;
        this.taskQueue = new LinkedList();
        this.threadMap = new HashMap<String, PoolTask>();
        this.taskSet = new HashSet<String>();
        for (int i = 0; i < numThreads; ++i) {
            new PooledThread().start();
        }
    }

    public synchronized void close() {
        if (this.threadPoolIsAlive) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Close Thread Pool", new Exception());
            }
            this.threadPoolIsAlive = false;
            this.taskQueue.clear();
            this.interrupt();
        }
    }

    protected synchronized PoolTask getTask() throws InterruptedException {
        while (this.taskQueue.size() == 0) {
            if (!this.threadPoolIsAlive) {
                return null;
            }
            this.wait();
        }
        PoolTask task = this.taskQueue.removeFirst();
        this.taskSet.remove(task.getThreadId());
        return task;
    }

    public synchronized PoolTask getTaskById(String id) {
        return this.threadMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.threadPoolIsAlive = false;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeTask(String threadId) {
        PoolTask thread = this.threadMap.get(threadId);
        if (thread != null) {
            thread.stopThread();
            this.threadMap.remove(threadId);
        }
    }

    public synchronized void runTask(PoolTask task, boolean priorityTask) {
        if (!this.threadPoolIsAlive) {
            throw new IllegalStateException();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Add task to queue");
        }
        if (task != null) {
            if (!this.taskSet.contains(task.getThreadId())) {
                if (priorityTask) {
                    this.taskQueue.addFirst(task);
                } else {
                    this.taskQueue.add(task);
                }
                this.taskSet.add(task.getThreadId());
            }
            if (!this.taskQueue.isEmpty()) {
                this.notify();
            }
        }
    }

    public class PooledThread
    extends Thread {
        String thrId;
        private boolean timedOut;

        public PooledThread() {
            super((ThreadGroup)ThreadPool.this, ThreadPool.this.getName() + ThreadPool.this.threadID++);
            this.timedOut = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted() && !this.timedOut) {
                    PoolTask task = null;
                    try {
                        task = ThreadPool.this.getTask();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "Error while waiting for task", ex);
                    }
                    if (task == null) {
                        return;
                    }
                    ControlTimerTask timerTask = new ControlTimerTask(this);
                    try {
                        this.thrId = task.getThreadId();
                        ThreadPool.this.threadMap.put(this.thrId, task);
                        ThreadPool.this.timer.schedule((TimerTask)timerTask, 10000L);
                        task.run();
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, "Error in pooled thread", t);
                        ThreadPool.this.uncaughtException(this, t);
                    }
                    finally {
                        timerTask.complete();
                        ThreadPool.this.threadMap.remove(this.thrId);
                    }
                }
            }
            finally {
                if (this.timedOut) {
                    LOGGER.fine("Thread timed out");
                }
                if (this.isInterrupted() && !this.timedOut) {
                    if (ThreadPool.this.threadPoolIsAlive) {
                        LOGGER.fine("Creating replacement thread");
                        new PooledThread().start();
                    }
                    LOGGER.fine("Thread was interrupted");
                }
                LOGGER.fine("Exiting pooled thread");
            }
        }
    }

    class ControlTimerTask
    extends TimerTask {
        PooledThread thread;
        private boolean completed;

        public ControlTimerTask(PooledThread thread) {
            this.thread = thread;
            this.completed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            ControlTimerTask controlTimerTask = this;
            synchronized (controlTimerTask) {
                this.completed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Check task thread for timeout");
            }
            ControlTimerTask controlTimerTask = this;
            synchronized (controlTimerTask) {
                if (!this.completed) {
                    this.thread.timedOut = true;
                    LOGGER.fine(String.format("Thread %1$s did not complete in 10 seconds so creating new thread!", this.thread.thrId));
                    if (ThreadPool.this.threadPoolIsAlive) {
                        new PooledThread().start();
                    }
                }
            }
        }
    }
}

