/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.billingservice.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.billingservice.client.dto.ContractRowState;
import com.dsoft.powerpro.billingservice.client.dto.ContractRowType;
import com.dsoft.powerpro.billingservice.client.dto.RowDependencyDTO;
import com.dsoft.powerpro.billingservice.client.dto.RowStateDTO;
import com.dsoft.powerpro.billingservice.client.dto.ServiceDTO;
import com.dsoft.powerpro.crm.client.dto.AreaDTO;
import com.dsoft.powerpro.crm.client.dto.ClientDto;
import com.dsoft.powerpro.crm.client.dto.ContractDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@ServerLoader(value="ContractRowLoaderLocal")
public class ContractRowDTO
extends HistoryDTO {
    public static final int SS_STOPPED = 0;
    public static final int SS_FORCE_SUSPENDED = 1;
    public static final int SS_ACTIVE = 2;
    public static final int SS_SUSPENDED = 3;
    public static final int SS_SERVICE_CHANGED = 4;
    public static final int SS_PHYSICALLY_DISCONNECTED = 5;
    private Integer rowNumber;
    private Long lastStopping;
    private Long lastStarting;
    private String notes;
    private String stateNotes;
    private Long firstActivating;
    private boolean stateFinished;
    private Integer lastTaskType;
    public static final String AddressDTO = "addressDTO";
    private static final String ContractDTO = "contractDTO";
    private static final String AreaProperty = "AreaProperty";
    private static final String ParentRow = "parentRow";
    private static final String NewRow = "previousRow";
    private static final String ClientDto = "ClientDto";
    private Map<Integer, RowDependencyDTO> dependency = new HashMap<Integer, RowDependencyDTO>();
    private ContractRowType rowType;
    private Set<RowStateDTO> rowStates = new TreeSet<RowStateDTO>();
    public static final String SERVICE = "service";

    public ContractRowDTO() {
        this.registerProperty(AddressDTO.class, AddressDTO);
        this.registerProperty(ContractDTO.class, ContractDTO, false);
        this.registerProperty(ClientDto.class, ClientDto, false);
        this.registerProperty(ServiceDTO.class, SERVICE, false);
        this.registerProperty(AreaDTO.class, AreaProperty, false);
        this.registerProperty(ContractRowDTO.class, ParentRow, false);
        this.registerProperty(ContractRowDTO.class, NewRow, false);
    }

    public static ContractRowState getState(int taskType) {
        switch (taskType) {
            case 0: 
            case 1: 
            case 5: {
                return ContractRowState.ACTIVE;
            }
            case 2: {
                return ContractRowState.STOPPED;
            }
            case 3: {
                return ContractRowState.SUSPENDED;
            }
            case 4: {
                return ContractRowState.FORCE_SUSPENDED;
            }
            case 8: {
                return ContractRowState.PHYSICALLY_DISCONNECTED;
            }
        }
        return ContractRowState.ACTIVE;
    }

    public ContractRowState getRowState() {
        if (this.getNewRowId() != null) {
            return ContractRowState.SERVICE_CHANGED;
        }
        if (this.lastTaskType != null) {
            return ContractRowDTO.getState(this.lastTaskType);
        }
        return ContractRowState.ACTIVE;
    }

    public String getStateNotes() {
        return this.stateNotes;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public String getNotes() {
        return this.notes;
    }

    public Long getLastStopping() {
        return this.lastStopping;
    }

    public Long getLastStarting() {
        return this.lastStarting;
    }

    public boolean isStateFinished() {
        return this.stateFinished;
    }

    public Long getFirstActivating() {
        return this.firstActivating;
    }

    public Integer getContractId() {
        return (Integer)this.getObjectValue(ContractDTO);
    }

    public void setStateNotes(String stateNotes) {
        this.setModified(this.stateNotes, stateNotes, "stateNotes");
        this.stateNotes = stateNotes;
    }

    public void setRowNumber(Integer rowNumber) {
        this.setModified(this.rowNumber, rowNumber, "rowNumber");
        this.rowNumber = rowNumber;
    }

    public void setNotes(String notes) {
        this.setModified(this.notes, notes, "notes");
        this.notes = notes;
    }

    public void setLastStopping(Long lastStopping) {
        this.setModified(this.lastStopping, lastStopping, "lastStopping");
        this.lastStopping = lastStopping;
    }

    public void setLastStarting(Long lastStarting) {
        this.setModified(this.lastStarting, lastStarting, "lastStarting");
        this.lastStarting = lastStarting;
    }

    public void setStateFinished(boolean stateFinished) {
        this.setModified(this.stateFinished, stateFinished, "stateFinished");
        this.stateFinished = stateFinished;
    }

    public void setFirstActivating(Long firstActivating) {
        this.setModified(this.firstActivating, firstActivating, "firstActivating");
        this.firstActivating = firstActivating;
    }

    public void setContractId(Integer contractId) {
        this.putObjectValue(ContractDTO, contractId);
    }

    public AddressDTO getAddressDTO() throws DTOFindException {
        return (AddressDTO)this.getPropertyValue(AddressDTO);
    }

    public void setAddressDTO(AddressDTO addressDto) {
        this.setProperty(AddressDTO, addressDto);
    }

    public Integer getServiceId() {
        return (Integer)this.getObjectValue(SERVICE);
    }

    public Integer getAreaId() {
        return (Integer)this.getObjectValue(AreaProperty);
    }

    public Integer getAddressId() {
        return (Integer)this.getObjectValue(AddressDTO);
    }

    public Integer getClientId() {
        return (Integer)this.getObjectValue(ClientDto);
    }

    public Integer getParentRowId() {
        return (Integer)this.getObjectValue(ParentRow);
    }

    public Integer getNewRowId() {
        return (Integer)this.getObjectValue(NewRow);
    }

    public ContractRowType getRowType() {
        return this.rowType;
    }

    public Integer getLastTaskType() {
        return this.lastTaskType;
    }

    public void addRowState(RowStateDTO rowStateDto) {
        this.rowStates.add(rowStateDto);
    }

    public List<RowStateDTO> getRowStates() {
        return new ArrayList<RowStateDTO>(this.rowStates);
    }

    public String getRowIdentifier() {
        return ContractRowDTO.getRowIdentifier(this.getId());
    }

    public void setServiceId(Integer serviceId) {
        this.putObjectValue(SERVICE, serviceId);
    }

    public void setAreaId(Integer areaId) {
        this.putObjectValue(AreaProperty, areaId);
    }

    public void setAddressId(Integer addressId) {
        this.putObjectValue(AddressDTO, addressId);
    }

    public void setClientId(Integer clientId) {
        this.putObjectValue(ClientDto, clientId);
    }

    public void setParentRowId(Integer parentRowId) {
        this.putObjectValue(ParentRow, parentRowId);
    }

    public void setNewRowId(Integer newRowId) {
        this.putObjectValue(NewRow, newRowId);
    }

    public void setRowType(ContractRowType rowType) {
        this.setModified((Object)this.rowType, (Object)rowType, "rowType");
        this.rowType = rowType;
    }

    public void setLastTaskType(Integer lastTaskType) {
        this.setModified(this.lastTaskType, lastTaskType, "lastTaskType");
        this.lastTaskType = lastTaskType;
    }

    public ContractRowDTO getParentRow() throws DTOFindException {
        return (ContractRowDTO)this.getPropertyValue(ParentRow);
    }

    public ContractRowDTO getNewRow() throws DTOFindException {
        return (ContractRowDTO)this.getPropertyValue(NewRow);
    }

    public ContractDTO getContractDTO() throws DTOFindException {
        return (ContractDTO)this.getPropertyValue(ContractDTO);
    }

    public ClientDto getClient() throws DTOFindException {
        return (ClientDto)this.getPropertyValue(ClientDto);
    }

    public ServiceDTO getService() throws DTOFindException {
        return (ServiceDTO)this.getPropertyValue(SERVICE);
    }

    public AreaDTO getArea() throws DTOFindException {
        return (AreaDTO)this.getPropertyValue(AreaProperty);
    }

    public Map<Integer, RowDependencyDTO> getDependencyMap() {
        return this.dependency;
    }

    public RowDependencyDTO addDependency(Integer groupNumber, Integer reqRowId, Integer reqContractId, Long validFrom, Long validTo, boolean addressDependency) {
        RowDependencyDTO depDto = new RowDependencyDTO();
        depDto.setRequiredRowId(reqRowId);
        depDto.setRowId(this.getId());
        depDto.setAddressDependency(addressDependency);
        depDto.setValidFrom(validFrom);
        depDto.setValidTo(validTo);
        depDto.setGroupNumber(groupNumber);
        depDto.setReqContractId(reqContractId);
        if (groupNumber == null) {
            int i = -1;
            while (this.dependency.keySet().contains(i)) {
                --i;
            }
            groupNumber = i;
        }
        this.dependency.put(groupNumber, depDto);
        return depDto;
    }

    public static String getRowIdentifier(Integer id) {
        if (id != null) {
            StringBuilder sb = new StringBuilder(id.toString());
            while (sb.length() < 10) {
                sb.insert(0, '0');
            }
            sb.insert(0, "PP_");
            return sb.toString();
        }
        return null;
    }

    public static Integer getRowId(String rowIdentifier) {
        if (ContractRowDTO.isValidRowIdentifier(rowIdentifier)) {
            return Integer.parseInt(rowIdentifier.substring(3));
        }
        return null;
    }

    public static boolean isValidRowIdentifier(String rowIdentifier) {
        return rowIdentifier != null && rowIdentifier.startsWith("PP_") && rowIdentifier.length() == 13;
    }
}

