/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.billingservice.client.dto;

import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.billingservice.client.dto.ContractRowDTO;
import com.dsoft.powerpro.billingservice.client.dto.ServiceDTO;
import com.dsoft.powerpro.crm.client.dto.ContractDTO;

public class RowDependencyDTO
extends BaseDTO {
    private static final String REQ_CONTRACT = "reqContract";
    private static final String SERVICE = "service";
    private static final String REQUIRED_SERVICE = "requiredService";
    private boolean addressDependency;
    private Integer requiredServiceId;
    private Long validFrom;
    private Long validTo;
    private Integer groupNumber;
    private static String reqRow = "requeredContractRow";
    private static String row = "contractRow";

    public RowDependencyDTO() {
        this.registerProperty(ContractRowDTO.class, reqRow, false);
        this.registerProperty(ContractRowDTO.class, row, false);
        this.registerProperty(ServiceDTO.class, REQUIRED_SERVICE, false);
        this.registerProperty(ServiceDTO.class, SERVICE, false);
        this.registerProperty(ContractDTO.class, REQ_CONTRACT, false);
    }

    public ContractRowDTO getRequieredContractRow() throws DTOFindException {
        return (ContractRowDTO)this.getPropertyValue(reqRow);
    }

    public ContractRowDTO getContractRow() throws DTOFindException {
        return (ContractRowDTO)this.getPropertyValue(row);
    }

    public ServiceDTO getRequiredService() throws DTOFindException {
        return (ServiceDTO)this.getPropertyValue(REQUIRED_SERVICE, this.requiredServiceId);
    }

    public ServiceDTO getService() throws DTOFindException {
        return (ServiceDTO)this.getPropertyValue(SERVICE);
    }

    public Integer getRequiredServiceId() {
        return this.requiredServiceId;
    }

    public void setRequiredServiceId(Integer requiredServiceId) {
        if (this.setModified(this.requiredServiceId, requiredServiceId, REQUIRED_SERVICE)) {
            this.removeProperty(REQUIRED_SERVICE, this.requiredServiceId);
        }
        this.requiredServiceId = requiredServiceId;
    }

    public void setRequiredRowId(Integer id) {
        this.putObjectValue(reqRow, id);
    }

    public Integer getRequiredRowId() {
        return (Integer)this.getObjectValue(reqRow);
    }

    public void setValidTo(Long validTo) {
        this.setModified(this.validTo, validTo, "validTo");
        this.validTo = validTo;
    }

    public void setValidFrom(Long validFrom) {
        this.setModified(this.validFrom, validFrom, "validFrom");
        this.validFrom = validFrom;
    }

    public void setRowId(Integer rowId) {
        this.putObjectValue(row, rowId);
    }

    public void setServiceId(Integer serviceId) {
        this.putObjectValue(SERVICE, serviceId);
    }

    public void setGroupNumber(Integer groupNumber) {
        this.setModified(this.groupNumber, groupNumber, "groupNumber");
        this.groupNumber = groupNumber;
    }

    public ContractDTO getRequieredContract() throws DTOFindException {
        return (ContractDTO)this.getPropertyValue(REQ_CONTRACT);
    }

    public void setReqContractId(Integer reqContractId) {
        this.putObjectValue(REQ_CONTRACT, reqContractId);
    }

    public void setAddressDependency(boolean addressDependency) {
        this.setModified(this.addressDependency, addressDependency, "addressDependency");
        this.addressDependency = addressDependency;
    }

    public Long getValidTo() {
        return this.validTo;
    }

    public Long getValidFrom() {
        return this.validFrom;
    }

    public Integer getRowId() {
        return (Integer)this.getObjectValue(row);
    }

    public Integer getServiceId() {
        return (Integer)this.getObjectValue(SERVICE);
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public Integer getReqContractId() {
        return (Integer)this.getObjectValue(REQ_CONTRACT);
    }

    public boolean isAddressDependency() {
        return this.addressDependency;
    }

    public boolean isValid(long timeStamp) {
        long validFrom = this.getValidFrom() != null ? this.getValidFrom() : 0L;
        long validTo = this.getValidTo() != null ? this.getValidTo() : Long.MAX_VALUE;
        return validFrom <= timeStamp && timeStamp <= validTo;
    }

    public boolean isCorrect() {
        return this.groupNumber != null && this.groupNumber >= 0;
    }
}

