/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.billingservice.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.billingservice.client.dto.ReadingModuleDTO;
import com.dsoft.powerpro.billingservice.client.dto.ServiceDependencyDTO;
import com.dsoft.powerpro.servicebase.client.dto.BaseServiceDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@ServerLoader(value="ServiceLoaderLocal")
public class ServiceDTO
extends BaseServiceDTO {
    private ReadingModuleDTO readingDevice;
    private boolean requiresNewContract;
    private Map<Integer, ServiceDependencyDTO> dependencyMap = new HashMap<Integer, ServiceDependencyDTO>();
    private Map<Integer, List<ServiceDependencyDTO>> groupDepMap = new HashMap<Integer, List<ServiceDependencyDTO>>();

    public void setReadingDevice(ReadingModuleDTO readingDevice) {
        this.setModified(this.readingDevice, readingDevice, "readingDevice");
        this.readingDevice = readingDevice;
    }

    public ReadingModuleDTO getReadingDevice() {
        return this.readingDevice;
    }

    public void setRequiresNewContract(boolean requiresNewContract) {
        this.setModified(this.requiresNewContract, requiresNewContract, "requiresNewContract");
        this.requiresNewContract = requiresNewContract;
    }

    public boolean isRequiresNewContract() {
        return this.requiresNewContract;
    }

    public Map<Integer, ServiceDependencyDTO> getServiceDependancyMap() {
        return new HashMap<Integer, ServiceDependencyDTO>(this.dependencyMap);
    }

    public ServiceDependencyDTO addMetaDependancy(Integer serviceId, Integer groupNumber, int flag) {
        ServiceDependencyDTO dep = new ServiceDependencyDTO();
        dep.setParent(this);
        dep.setFlag(flag);
        dep.setGroupNumber(groupNumber);
        dep.setServiceId(serviceId);
        this.dependencyMap.put(serviceId, dep);
        List<ServiceDependencyDTO> depForGroup = this.groupDepMap.get(groupNumber);
        if (depForGroup == null) {
            depForGroup = new ArrayList<ServiceDependencyDTO>();
            this.groupDepMap.put(groupNumber, depForGroup);
        }
        depForGroup.add(dep);
        this.setModified("metaDependency");
        return dep;
    }

    public void removeMetaDependancy(Integer serviceId) {
        List<ServiceDependencyDTO> depForGroup;
        ServiceDependencyDTO dep = this.dependencyMap.remove(serviceId);
        if (this.setModified(dep, null, "metaDependancy") && (depForGroup = this.groupDepMap.get(dep.getGroupNumber())) != null) {
            depForGroup.remove(dep);
            if (depForGroup.size() == 0) {
                this.groupDepMap.remove(dep.getGroupNumber());
            }
        }
    }

    public List<ServiceDependencyDTO> getActiveMetaDependancy() throws DTOFindException {
        List<ServiceDependencyDTO> dependancyList = this.getAllMetaDependencies();
        for (int i = dependancyList.size() - 1; i >= 0; --i) {
            ServiceDependencyDTO dep = dependancyList.get(i);
            if (dep.getService().isActive()) continue;
            dependancyList.remove(i);
        }
        return dependancyList;
    }

    public List<ServiceDependencyDTO> getGroupDependencies(Integer groupNumber) {
        List<ServiceDependencyDTO> depForGroup = this.groupDepMap.get(groupNumber);
        if (depForGroup == null) {
            depForGroup = new ArrayList<ServiceDependencyDTO>();
            this.groupDepMap.put(groupNumber, depForGroup);
        }
        return depForGroup;
    }

    public List<Integer> getDependancyGroups(boolean active) throws DTOFindException {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ServiceDependencyDTO dto : this.dependencyMap.values()) {
            if (active && !dto.getService().isActive()) continue;
            result.add(dto.getGroupNumber());
        }
        return new ArrayList<Integer>(result);
    }

    public List<ServiceDependencyDTO> getAllMetaDependencies() {
        ArrayList<ServiceDependencyDTO> dependancyList = new ArrayList<ServiceDependencyDTO>(this.dependencyMap.values());
        Collections.sort(dependancyList, new Comparator<ServiceDependencyDTO>(){

            @Override
            public int compare(ServiceDependencyDTO d1, ServiceDependencyDTO d2) {
                return d1.getGroupNumber().compareTo(d2.getGroupNumber());
            }
        });
        return dependancyList;
    }

    public boolean isServiceAddressDepended() throws DTOFindException {
        for (ServiceDependencyDTO dep : this.getActiveMetaDependancy()) {
            if (!dep.isAddressDependency()) continue;
            return true;
        }
        return false;
    }
}

