/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.cablemodem.client.dto;

import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.exception.DSoftException;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.cablemodem.client.dto.CableModemModelDto;
import com.dsoft.powerpro.cablemodem.client.dto.CmtsDto;
import com.dsoft.powerpro.cablemodem.client.dto.FilterListDTO;
import com.dsoft.powerpro.cablemodem.client.dto.FilterType;
import com.dsoft.powerpro.cablemodem.client.dto.LLCListDto;
import com.dsoft.powerpro.cablemodem.client.dto.NMAccessListDto;
import com.dsoft.powerpro.cablemodem.client.dto.ServiceFlowGroupDTO;
import com.dsoft.powerpro.cablemodem.client.dto.UpstreamDto;
import com.dsoft.powerpro.internet.client.dto.ConfigFileDeviceDto;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceDto;
import java.util.HashSet;

public class CableModemDto
extends ConfigFileDeviceDto {
    private static final String MODEM_TYPE = "modemType";
    private static final String FILTER_LIST = "filterList";
    private static final String NM_ACCESS_LIST = "nmAccessList";
    private static final String LLC_LIST = "llcList";
    private static final String UPSTREAM = "upstream";
    private static final String CMTS = "Cmts";
    private boolean disabled = true;
    private Integer maxCpe = 0;
    private DTOSet<NetworkDeviceDto, Integer> cpeDevices = new DTOSet(NetworkDeviceDto.class, this);
    private Integer cableModemTypeId;
    private Integer cmtsId;
    private Integer nmAccessListId;
    private Integer filterListId;
    private Integer upstreamId;
    private FilterType filterType = FilterType.NO_FILTER;
    private String upgradeFile;
    private Integer llcId;
    private boolean boundedWithType = false;
    private Integer qosId;
    private DTOSet<ServiceFlowGroupDTO, Integer> modemFlowGroups = new DTOSet(ServiceFlowGroupDTO.class, this);
    private HashSet<Integer> enabledFlowGroups = new HashSet();
    private Integer maxClassifiers;

    public CableModemDto() {
        this.registerProperty(CmtsDto.class, CMTS, false);
        this.registerProperty(UpstreamDto.class, UPSTREAM, false);
        this.registerProperty(LLCListDto.class, LLC_LIST, false);
        this.registerProperty(NMAccessListDto.class, NM_ACCESS_LIST, false);
        this.registerProperty(FilterListDTO.class, FILTER_LIST, false);
        this.registerProperty(CableModemModelDto.class, MODEM_TYPE, false);
        this.setInfrastructureDevice(true);
    }

    @Override
    protected boolean allowDynamicHosts() {
        return false;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "cable modem";
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.setModified(this.disabled, disabled, "disabled");
        this.disabled = disabled;
    }

    public Integer getMaxCpe() {
        return this.maxCpe;
    }

    public void setMaxCpe(Integer maxCpe) {
        this.setModified(this.maxCpe, maxCpe, "maxCpe");
        this.maxCpe = maxCpe;
    }

    public DTOSet<NetworkDeviceDto, Integer> getCPEList() {
        return this.cpeDevices;
    }

    public Integer getCableModemTypeId() {
        return this.cableModemTypeId;
    }

    public Integer getCmtsId() {
        return this.cmtsId;
    }

    public Integer getLlcId() {
        return this.llcId;
    }

    public Integer getUpstreamId() {
        return this.upstreamId;
    }

    public String getUpgradeFile() {
        return this.upgradeFile != null ? this.upgradeFile.trim() : null;
    }

    public Integer getNmAccessListId() {
        return this.nmAccessListId;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Integer getFilterListId() {
        return this.filterListId;
    }

    public Integer getCableModemQos() {
        return this.qosId;
    }

    public Integer getMaxClassifiers() {
        return this.maxClassifiers;
    }

    public DTOSet<ServiceFlowGroupDTO, Integer> getModemFlowGroups() {
        return this.modemFlowGroups;
    }

    public void enableFlowGroup(Integer flowGroupId) {
        if (this.modemFlowGroups.containsId(flowGroupId)) {
            this.setModified(this.enabledFlowGroups.add(flowGroupId), false, "flowGroup");
        }
    }

    public void disableFlowGroup(Integer flowGroupId) {
        if (this.modemFlowGroups.containsId(flowGroupId)) {
            this.setModified(this.enabledFlowGroups.remove(flowGroupId), false, "flowGroup");
        }
    }

    public HashSet<Integer> getEnabledFlowGroups() {
        return new HashSet<Integer>(this.enabledFlowGroups);
    }

    public boolean isBoundedWithType() {
        return this.boundedWithType;
    }

    public CableModemModelDto getModemType() throws DTOFindException {
        return (CableModemModelDto)this.getPropertyValue(MODEM_TYPE, this.cableModemTypeId);
    }

    public void setCableModemTypeId(Integer cableModemTypeId) {
        if (this.setModified(this.cableModemTypeId, cableModemTypeId, MODEM_TYPE)) {
            this.removeProperty(MODEM_TYPE, this.cableModemTypeId);
        }
        this.cableModemTypeId = cableModemTypeId;
    }

    public CmtsDto getCmts() throws DTOFindException {
        return (CmtsDto)this.getPropertyValue(CMTS, this.cmtsId);
    }

    public void setCmtsId(Integer cmtsId) {
        if (this.setModified(this.cmtsId, cmtsId, CMTS)) {
            this.removeProperty(CMTS, this.cmtsId);
        }
        this.cmtsId = cmtsId;
    }

    public LLCListDto getLLCList() throws DTOFindException {
        return (LLCListDto)this.getPropertyValue(LLC_LIST, this.llcId);
    }

    public void setLlcId(Integer llcId) {
        if (this.setModified(this.llcId, llcId, LLC_LIST)) {
            this.removeProperty(LLC_LIST, this.llcId);
        }
        this.llcId = llcId;
    }

    public UpstreamDto getUpstream() throws DTOFindException {
        return (UpstreamDto)this.getPropertyValue(UPSTREAM, this.upstreamId);
    }

    public void setUpstreamId(Integer upstreamId) {
        if (this.setModified(this.upstreamId, upstreamId, UPSTREAM)) {
            this.removeProperty(UPSTREAM, this.upstreamId);
        }
        this.upstreamId = upstreamId;
    }

    public void setUpgradeFile(String upgradeFile) {
        this.setModified(this.upgradeFile, upgradeFile, "upgradeFile");
        this.upgradeFile = upgradeFile;
    }

    public NMAccessListDto getNMAccessList() throws DTOFindException {
        return (NMAccessListDto)this.getPropertyValue(NM_ACCESS_LIST, this.nmAccessListId);
    }

    public void setNmAccessListId(Integer nmAccessListId) {
        if (this.setModified(this.nmAccessListId, nmAccessListId, NM_ACCESS_LIST)) {
            this.removeProperty(NM_ACCESS_LIST, this.nmAccessListId);
        }
        this.nmAccessListId = nmAccessListId;
    }

    public void setFilterType(FilterType filterType) {
        this.setModified((Object)this.filterType, (Object)filterType, "filterType");
        this.filterType = filterType;
    }

    public FilterListDTO getFilterList() throws DTOFindException {
        return (FilterListDTO)this.getPropertyValue(FILTER_LIST, this.filterListId);
    }

    public void setFilterListId(Integer filterListId) {
        if (this.setModified(this.filterListId, filterListId, FILTER_LIST)) {
            this.removeProperty(FILTER_LIST, this.filterListId);
        }
        this.filterListId = filterListId;
    }

    public void setCableModemQos(Integer qosId) {
        this.setModified(this.qosId, qosId, "qosId");
        this.qosId = qosId;
    }

    public void setMaxClassifiers(Integer maxClassifiers) {
        this.maxClassifiers = maxClassifiers;
    }

    public void setBoundedWithType(boolean boundedWithType) {
        this.setModified(this.boundedWithType, boundedWithType, "boundedWithType");
        this.boundedWithType = boundedWithType;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public void updateConfigFileOption() throws DSoftException {
        super.updateConfigFileOption("cm", "md5");
    }

    public boolean isEnabledFlowGroup(Integer flowGroupId) {
        return this.enabledFlowGroups.contains(flowGroupId);
    }
}

