/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.cablemodem.client.dto;

import com.dsoft.framework.client.exception.DSoftException;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.exception.InvalidIPFormatException;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.cablemodem.client.TriState;
import com.dsoft.powerpro.cablemodem.client.dto.FilterListDTO;
import com.dsoft.powerpro.cablemodem.client.dto.LLCListDto;
import com.dsoft.powerpro.cablemodem.client.dto.NMAccessListDto;
import com.dsoft.powerpro.cablemodem.client.dto.UpstreamListDto;
import com.dsoft.powerpro.cablemodem.mserver.DOCSIS;
import com.dsoft.powerpro.internet.client.dto.ConfigFileDeviceDto;

public class CmtsDto
extends ConfigFileDeviceDto {
    private static final String FILTER_LIST = "filterList";
    private static final String NM_ACCESS_LIST = "nmAccessList";
    private static final String UPSTREAM_LIST = "UpstreamList";
    private static final String LLC_LIST = "llcList";
    private Integer downstreamFrequency = 0;
    private String md5key;
    private Long upgradeServer;
    private String notes;
    private Integer chanelWidth = 0;
    private Integer modulationType = 0;
    private Integer interleave = 0;
    private Integer power = 0;
    private String upgradeFile;
    private DOCSIS docsis;
    private TriState globalPrivacyState;

    public CmtsDto() {
        this.registerProperty(LLCListDto.class, LLC_LIST, false);
        this.registerProperty(UpstreamListDto.class, UPSTREAM_LIST, false);
        this.registerProperty(NMAccessListDto.class, NM_ACCESS_LIST, false);
        this.registerProperty(FilterListDTO.class, FILTER_LIST, false);
        this.setForInternalUse(true);
        this.setInfrastructureDevice(true);
    }

    @Override
    protected boolean allowDynamicHosts() {
        return false;
    }

    public Integer getDownstreamFrequency() {
        return this.downstreamFrequency;
    }

    public void setDownstreamFrequency(Integer downstreamFrequency) {
        this.setModified(this.downstreamFrequency, downstreamFrequency);
        this.downstreamFrequency = downstreamFrequency;
    }

    public String getMd5key() {
        return this.md5key;
    }

    public void setMd5key(String md5key) {
        this.setModified(this.md5key, md5key);
        this.md5key = md5key;
    }

    public void setUpgradeServer(String upgradeServer) throws InvalidIPFormatException {
        Long newUpgradeServer = IPUtils.ipStringToLong2(upgradeServer);
        this.setModified(this.upgradeServer, newUpgradeServer);
        this.upgradeServer = newUpgradeServer;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.setModified(this.notes, notes);
        this.notes = notes;
    }

    public Integer getChanelWidth() {
        return this.chanelWidth;
    }

    public void setChanelWidth(Integer chanelWidth) {
        this.setModified(this.chanelWidth, chanelWidth);
        this.chanelWidth = chanelWidth;
    }

    public Integer getModulationType() {
        return this.modulationType;
    }

    public void setModulationType(Integer modulationType) {
        this.setModified(this.modulationType, modulationType);
        this.modulationType = modulationType;
    }

    public Integer getInterleave() {
        return this.interleave;
    }

    public void setInterleave(Integer interleave) {
        this.setModified(this.interleave, interleave);
        this.interleave = interleave;
    }

    public Integer getPower() {
        return this.power;
    }

    public DOCSIS getDocsis() {
        return this.docsis;
    }

    public Integer getUpstreamListId() {
        return (Integer)this.getObjectValue(UPSTREAM_LIST);
    }

    public String getUpgradeFile() {
        return this.upgradeFile;
    }

    public Long getUpgradeServerLong() {
        return this.upgradeServer;
    }

    public String getUpgradeServer() {
        return IPUtils.ipLongToString(this.upgradeServer);
    }

    public Integer getNmAccessListId() {
        return (Integer)this.getObjectValue(NM_ACCESS_LIST);
    }

    public Integer getLlcListId() {
        return (Integer)this.getObjectValue(LLC_LIST);
    }

    public Integer getIpFilterId() {
        return (Integer)this.getObjectValue(FILTER_LIST);
    }

    public TriState getGlobalPrivacyState() {
        return this.globalPrivacyState;
    }

    public void setPower(Integer power) {
        this.setModified(this.power, power);
        this.power = power;
    }

    public void setDocsis(DOCSIS docsis) {
        this.setModified((Object)this.docsis, (Object)docsis, "docsis");
        this.docsis = docsis;
    }

    public UpstreamListDto getUpstreamList() throws DTOFindException {
        return (UpstreamListDto)this.getPropertyValue(UPSTREAM_LIST);
    }

    public void setUpstreamListId(Integer upstreamListId) {
        this.putObjectValue(UPSTREAM_LIST, upstreamListId);
    }

    public void setUpgradeFile(String upgradeFile) {
        this.setModified(this.upgradeFile, upgradeFile);
        this.upgradeFile = upgradeFile;
    }

    public NMAccessListDto getNMAccessList() throws DTOFindException {
        return (NMAccessListDto)this.getPropertyValue(NM_ACCESS_LIST);
    }

    public void setNmAccessListId(Integer nmAccessListId) {
        this.putObjectValue(NM_ACCESS_LIST, nmAccessListId);
    }

    public LLCListDto getLLCList() throws DTOFindException {
        return (LLCListDto)this.getPropertyValue(LLC_LIST);
    }

    public void setLlcListId(Integer llcListId) {
        this.putObjectValue(LLC_LIST, llcListId);
    }

    public FilterListDTO getIPFilterList() throws DTOFindException {
        return (FilterListDTO)this.getPropertyValue(FILTER_LIST);
    }

    public void setIpFilterId(Integer ipFilterId) {
        this.putObjectValue(FILTER_LIST, ipFilterId);
    }

    public void setGlobalPrivacyState(TriState globalPrivacyState) {
        this.setModified((Object)this.globalPrivacyState, (Object)globalPrivacyState);
        this.globalPrivacyState = globalPrivacyState;
    }

    public void updateConfigFileOption() throws DSoftException {
        super.updateConfigFileOption("cmts", "md5");
    }
}

