/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.cablemodem.client.dto;

import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.powerpro.cablemodem.client.dto.ThresholdLevel;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PowerLevelThresholdsDto
extends IntegerIdDTO
implements Comparable<PowerLevelThresholdsDto> {
    public static final String DOWN_POWER = "down:power";
    public static final String DOWN_SNR = "down:snr";
    public static final String UP_TX_POWER = "up:power";
    public static final String UP_SNR = "up:snr";
    private String name;
    private ThresholdLevel level;
    private Double startValue;
    private Double endValue;
    private int color;
    private String direction;

    public PowerLevelThresholdsDto() {
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public void setLevel(ThresholdLevel level) {
        this.setModified((Object)this.level, (Object)level, "level");
        this.level = level;
    }

    public void setStartValue(Double startValue) {
        this.setModified(this.startValue, startValue, "startValue");
        this.startValue = startValue;
    }

    public void setEndValue(Double endValue) {
        this.setModified(this.endValue, endValue, "endValue");
        this.endValue = endValue;
    }

    public void setColor(int color) {
        this.setModified(this.color, color, "color");
        this.color = color;
    }

    public void setDirection(String direction) {
        this.setModified(this.direction, direction, "direction");
        this.direction = direction;
    }

    @Override
    public int compareTo(PowerLevelThresholdsDto o) {
        return this.startValue.compareTo(o.getStartValue());
    }

    public boolean contains(Double value) {
        long val = Math.round(value * 10.0);
        return Math.round(this.startValue * 10.0) <= val && val < Math.round(this.endValue * 10.0);
    }

    public static Map<String, List<PowerLevelThresholdsDto>> buildThresholdsMap(List<PowerLevelThresholdsDto> thresholds) {
        HashMap<String, List<PowerLevelThresholdsDto>> thresholdsMap = new HashMap<String, List<PowerLevelThresholdsDto>>();
        for (PowerLevelThresholdsDto dto : thresholds) {
            ArrayList<PowerLevelThresholdsDto> list = (ArrayList<PowerLevelThresholdsDto>)thresholdsMap.get(dto.getName());
            if (list == null) {
                list = new ArrayList<PowerLevelThresholdsDto>();
                thresholdsMap.put(dto.getName(), list);
            }
            list.add(dto);
        }
        for (List thresholdsDtoList : thresholdsMap.values()) {
            Collections.sort(thresholdsDtoList);
        }
        return thresholdsMap;
    }

    public static int findThresholdColor(double value, List<PowerLevelThresholdsDto> list) {
        int color = 0xFFFFFF;
        if (list == null) {
            return 0;
        }
        for (PowerLevelThresholdsDto dto : list) {
            if (dto.getStartValue() < value && value < dto.getEndValue()) {
                return dto.getColor();
            }
            if (dto.getStartValue() == value) {
                return dto.getColor();
            }
            if (dto.getEndValue() == value && list.indexOf(dto) < list.size() - 1) {
                color = dto.getColor();
                continue;
            }
            if (dto.getEndValue() != value) continue;
            if (color != 0xFFFFFF) {
                return color;
            }
            return dto.getColor();
        }
        return 0;
    }

    public static PowerLevelThresholdsDtoBuilder builder() {
        return new PowerLevelThresholdsDtoBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerLevelThresholdsDto)) {
            return false;
        }
        PowerLevelThresholdsDto other = (PowerLevelThresholdsDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ThresholdLevel this$level = this.getLevel();
        ThresholdLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
            return false;
        }
        Double this$startValue = this.getStartValue();
        Double other$startValue = other.getStartValue();
        if (this$startValue == null ? other$startValue != null : !((Object)this$startValue).equals(other$startValue)) {
            return false;
        }
        Double this$endValue = this.getEndValue();
        Double other$endValue = other.getEndValue();
        if (this$endValue == null ? other$endValue != null : !((Object)this$endValue).equals(other$endValue)) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        String this$direction = this.getDirection();
        String other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !this$direction.equals(other$direction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PowerLevelThresholdsDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ThresholdLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
        Double $startValue = this.getStartValue();
        result = result * 59 + ($startValue == null ? 43 : ((Object)$startValue).hashCode());
        Double $endValue = this.getEndValue();
        result = result * 59 + ($endValue == null ? 43 : ((Object)$endValue).hashCode());
        result = result * 59 + this.getColor();
        String $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PowerLevelThresholdsDto(super=" + super.toString() + ", name=" + this.getName() + ", level=" + (Object)((Object)this.getLevel()) + ", startValue=" + this.getStartValue() + ", endValue=" + this.getEndValue() + ", color=" + this.getColor() + ", direction=" + this.getDirection() + ")";
    }

    @ConstructorProperties(value={"name", "level", "startValue", "endValue", "color", "direction"})
    public PowerLevelThresholdsDto(String name, ThresholdLevel level, Double startValue, Double endValue, int color, String direction) {
        this.name = name;
        this.level = level;
        this.startValue = startValue;
        this.endValue = endValue;
        this.color = color;
        this.direction = direction;
    }

    public String getName() {
        return this.name;
    }

    public ThresholdLevel getLevel() {
        return this.level;
    }

    public Double getStartValue() {
        return this.startValue;
    }

    public Double getEndValue() {
        return this.endValue;
    }

    public int getColor() {
        return this.color;
    }

    public String getDirection() {
        return this.direction;
    }

    public static class PowerLevelThresholdsDtoBuilder {
        private String name;
        private ThresholdLevel level;
        private Double startValue;
        private Double endValue;
        private int color;
        private String direction;

        PowerLevelThresholdsDtoBuilder() {
        }

        public PowerLevelThresholdsDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PowerLevelThresholdsDtoBuilder level(ThresholdLevel level) {
            this.level = level;
            return this;
        }

        public PowerLevelThresholdsDtoBuilder startValue(Double startValue) {
            this.startValue = startValue;
            return this;
        }

        public PowerLevelThresholdsDtoBuilder endValue(Double endValue) {
            this.endValue = endValue;
            return this;
        }

        public PowerLevelThresholdsDtoBuilder color(int color) {
            this.color = color;
            return this;
        }

        public PowerLevelThresholdsDtoBuilder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public PowerLevelThresholdsDto build() {
            return new PowerLevelThresholdsDto(this.name, this.level, this.startValue, this.endValue, this.color, this.direction);
        }

        public String toString() {
            return "PowerLevelThresholdsDto.PowerLevelThresholdsDtoBuilder(name=" + this.name + ", level=" + (Object)((Object)this.level) + ", startValue=" + this.startValue + ", endValue=" + this.endValue + ", color=" + this.color + ", direction=" + this.direction + ")";
        }
    }
}

