/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.core.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.core.client.Messages;
import com.dsoft.powerpro.core.client.dto.JobPositionDTO;
import com.dsoft.powerpro.core.client.dto.OfficeDTO;
import com.dsoft.powerpro.core.client.dto.UnitDTO;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

@ServerLoader(value="EmployeeLoaderLocal")
public class EmployeeDTO
extends HistoryDTO {
    private String name = "";
    private String EGN = "";
    private String homePhones;
    private String workPhones;
    private Integer positionId;
    private Integer officeId;
    private Integer homeAddressId;
    private Integer unitId;
    private Integer manageUnitId;
    private Integer companyId;
    private static final String OfficeProperty = "OfficeProperty";
    private static final String JobProperty = "JobProperty";
    private static final String EmployeeOfUnit = "EmployeeOfUnit";
    private static final String ManagerForUnit = "ManagerForUnit";
    public static final String HomeAddress = "homeAddress";

    public EmployeeDTO() {
        this.registerProperty(AddressDTO.class, HomeAddress);
        this.registerProperty(OfficeDTO.class, OfficeProperty, false);
        this.registerProperty(JobPositionDTO.class, JobProperty, false);
        this.registerProperty(UnitDTO.class, EmployeeOfUnit, false);
        this.registerProperty(UnitDTO.class, ManagerForUnit, false);
    }

    public void setName(String str) throws PropertyVetoException {
        if (str == null || str.trim().length() == 0) {
            throw new PropertyVetoException(Messages.getString("EmployeeDTO.0"), new PropertyChangeEvent(this, "name", this.name, str));
        }
        this.setModified(this.name, str);
        this.name = str;
    }

    public OfficeDTO getOffice() throws DTOFindException {
        return (OfficeDTO)this.getPropertyValue(OfficeProperty, this.getOfficeId());
    }

    public void setOfficeId(Integer officeId) throws PropertyVetoException {
        if (officeId == null) {
            throw new PropertyVetoException(Messages.getString("EmployeeDTO.1"), new PropertyChangeEvent(this, "officeId", this.officeId, officeId));
        }
        if (this.setModified(this.officeId, officeId)) {
            this.removeProperty(OfficeProperty, this.getOfficeId());
        }
        this.officeId = officeId;
    }

    public void setPositionId(Integer jobPositionId) throws PropertyVetoException {
        if (jobPositionId == null) {
            throw new PropertyVetoException(Messages.getString("EmployeeDTO.2"), new PropertyChangeEvent(this, "jobPositionId", this.positionId, jobPositionId));
        }
        if (this.setModified(this.positionId, jobPositionId)) {
            this.removeProperty(JobProperty, this.positionId);
        }
        this.positionId = jobPositionId;
    }

    public JobPositionDTO getPosition() throws DTOFindException {
        return (JobPositionDTO)this.getPropertyValue(JobProperty, this.positionId);
    }

    public String getName() {
        return this.name;
    }

    public Integer getOfficeId() {
        return this.officeId;
    }

    public Integer getPositionId() {
        return this.positionId;
    }

    public void setEGN(String str) {
        this.setModified(this.EGN, str);
        this.EGN = str;
    }

    public String getEGN() {
        return this.EGN;
    }

    public void setHomePhones(String str) {
        this.setModified(this.homePhones, str);
        this.homePhones = str;
    }

    public String getHomePhones() {
        return this.homePhones;
    }

    public void setWorkPhones(String str) {
        this.setModified(this.workPhones, str);
        this.workPhones = str;
    }

    public void setHomeAddressId(Integer addressId) {
        if (this.setModified(this.homeAddressId, addressId)) {
            this.removeProperty(HomeAddress, this.homeAddressId);
        }
        this.homeAddressId = addressId;
    }

    public void setUnitId(Integer unitId) {
        if (this.setModified(this.unitId, unitId)) {
            this.removeProperty(EmployeeOfUnit, this.unitId);
        }
        this.unitId = unitId;
    }

    public void setManageUnitId(Integer manageUnitId) {
        if (this.setModified(this.manageUnitId, manageUnitId)) {
            this.removeProperty(ManagerForUnit, this.manageUnitId);
        }
        this.manageUnitId = manageUnitId;
    }

    public void setCompanyId(Integer companyId) {
        this.setModified(this.companyId, companyId, "Company");
        this.companyId = companyId;
    }

    public String getWorkPhones() {
        return this.workPhones;
    }

    public Integer getHomeAddressId() {
        return this.homeAddressId;
    }

    public Integer getUnitId() {
        return this.unitId;
    }

    public Integer getManageUnitId() {
        return this.manageUnitId;
    }

    public Integer getCompanyId() {
        return this.companyId;
    }

    public UnitDTO getUnit() throws DTOFindException {
        return (UnitDTO)this.getPropertyValue(EmployeeOfUnit, this.unitId);
    }

    public UnitDTO getManageUnit() throws DTOFindException {
        return (UnitDTO)this.getPropertyValue(ManagerForUnit, this.manageUnitId);
    }

    public AddressDTO getHomeAddress() throws DTOFindException {
        return (AddressDTO)this.getPropertyValue(HomeAddress, this.homeAddressId);
    }

    public void setHomeAddress(AddressDTO homeAddress) {
        if (homeAddress != null) {
            this.setHomeAddressId(homeAddress.getId());
        } else {
            this.setHomeAddressId(null);
        }
        this.setProperty(HomeAddress, this.getHomeAddressId(), homeAddress);
    }

    @Override
    public String toString() {
        return this.EGN;
    }
}

