/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.core.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.core.client.Messages;
import com.dsoft.powerpro.core.client.dto.CompanyDTO;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

@ServerLoader(value="OfficeLoaderLocal")
public class OfficeDTO
extends HistoryDTO
implements Comparable<OfficeDTO> {
    private String name;
    private String description;
    private String phones;
    private Integer officeAddressId;
    private Integer companyId;
    public static final String OfficeAddress = "officeAddress";
    private static final String Company = "Company";

    public OfficeDTO() {
        this.registerProperty(AddressDTO.class, OfficeAddress);
        this.registerProperty(CompanyDTO.class, Company, false);
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null || name.trim().length() == 0) {
            throw new PropertyVetoException(Messages.getString("OfficeDTO.0"), new PropertyChangeEvent(this, "name", this.name, name));
        }
        this.setModified(this.name, name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOfficeAddress(AddressDTO officeAddress) {
        if (officeAddress != null) {
            this.setOfficeAddressId(officeAddress.getId());
        } else {
            this.setOfficeAddressId(null);
        }
        this.setProperty(OfficeAddress, this.getOfficeAddressId(), officeAddress);
    }

    public AddressDTO getOfficeAddress() throws DTOFindException {
        return (AddressDTO)this.getPropertyValue(OfficeAddress, this.getOfficeAddressId());
    }

    public void setDescription(String description) {
        this.setModified(this.description, description);
        this.description = description;
    }

    public void setPhones(String phones) {
        this.setModified(this.phones, phones);
        this.phones = phones;
    }

    public void setOfficeAddressId(Integer addressId) {
        if (this.setModified(this.officeAddressId, addressId)) {
            this.removeProperty(OfficeAddress, this.getOfficeAddressId());
        }
        this.officeAddressId = addressId;
    }

    public void setCompanyId(Integer companyId) {
        if (this.setModified(this.companyId, companyId)) {
            this.removeProperty(Company, this.companyId);
        }
        this.companyId = companyId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPhones() {
        return this.phones;
    }

    public Integer getOfficeAddressId() {
        return this.officeAddressId;
    }

    public Integer getCompanyId() {
        return this.companyId;
    }

    public CompanyDTO getCompany() throws DTOFindException {
        return (CompanyDTO)this.getPropertyValue(Company, this.companyId);
    }

    @Override
    public int compareTo(OfficeDTO o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

