/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.core.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.HierarchicalItem;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.core.client.dto.CompanyDTO;

@ServerLoader(value="UnitLoaderLocal")
public class UnitDTO
extends HistoryDTO
implements HierarchicalItem<UnitDTO, Integer> {
    private static final String PARENT_UNIT = "ParentUnit";
    private static final String COMPANY = "Company";
    private String unitName;
    private Integer parentUnitId;
    private Integer companyId;
    private String description;

    public UnitDTO() {
        this.registerProperty(CompanyDTO.class, COMPANY, false);
        this.registerProperty(UnitDTO.class, PARENT_UNIT, true);
    }

    public CompanyDTO getCompany() {
        return (CompanyDTO)this.getPropertyValue(COMPANY, this.companyId);
    }

    public UnitDTO getParentUnit() {
        return (UnitDTO)this.getPropertyValue(PARENT_UNIT, this.parentUnitId);
    }

    public void setParentUnit(UnitDTO parentUnit) {
        this.removeProperty(PARENT_UNIT, this.parentUnitId);
        if (parentUnit != null) {
            this.setParentUnitId((Integer)parentUnit.getId());
        } else {
            this.setParentUnitId(null);
        }
        this.setProperty(PARENT_UNIT, this.parentUnitId, parentUnit);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.setModified(this.unitName, unitName);
        this.unitName = unitName;
    }

    public Integer getParentUnitId() {
        return this.parentUnitId;
    }

    public void setParentUnitId(Integer parentUnitId) {
        if (this.setModified(this.parentUnitId, parentUnitId)) {
            this.removeProperty(PARENT_UNIT, this.parentUnitId);
        }
        this.parentUnitId = parentUnitId;
    }

    public Integer getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Integer companyId) {
        if (this.setModified(this.companyId, companyId)) {
            this.removeProperty(COMPANY, this.companyId);
        }
        this.companyId = companyId;
    }

    public void setDescription(String description) {
        this.setModified(this.description, description);
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuffer returnStringBuffer = new StringBuffer(224);
        returnStringBuffer.append("[");
        returnStringBuffer.append("unitName:").append(this.unitName);
        returnStringBuffer.append("parentId:").append(this.parentUnitId);
        returnStringBuffer.append("companyId:").append(this.companyId);
        returnStringBuffer.append("]");
        return returnStringBuffer.toString();
    }

    @Override
    public String getName() {
        return this.unitName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public UnitDTO getParentItem() {
        return this.getParentUnit();
    }

    @Override
    public String getFullName() {
        return (this.parentUnitId != null ? this.getParentUnit().getFullName() : "") + "/" + this.unitName;
    }
}

