/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.core.client.utils;

import java.math.BigInteger;
import java.util.HashMap;

public class CoreUtils {
    private static final HashMap<String, Integer> ibanLengthMap = new HashMap<String, Integer>(){
        {
            this.put("AD", 24);
            this.put("AT", 20);
            this.put("BE", 16);
            this.put("BA", 20);
            this.put("BG", 22);
            this.put("HR", 21);
            this.put("CY", 28);
            this.put("CZ", 24);
            this.put("DK", 18);
            this.put("EE", 20);
            this.put("FO", 18);
            this.put("FI", 18);
            this.put("FR", 27);
            this.put("DE", 22);
            this.put("GI", 23);
            this.put("GR", 27);
            this.put("GL", 18);
            this.put("HU", 28);
            this.put("IS", 26);
            this.put("IE", 22);
            this.put("IT", 27);
            this.put("LV", 21);
            this.put("LI", 21);
            this.put("LT", 20);
            this.put("LU", 20);
            this.put("MK", 19);
            this.put("MT", 31);
            this.put("MC", 27);
            this.put("MA", 24);
            this.put("NL", 18);
            this.put("NO", 15);
            this.put("PL", 28);
            this.put("PT", 25);
            this.put("RO", 24);
            this.put("SM", 27);
            this.put("RS", 22);
            this.put("SK", 24);
            this.put("SI", 19);
            this.put("ES", 24);
            this.put("SE", 24);
            this.put("CH", 21);
            this.put("TR", 26);
            this.put("TN", 24);
            this.put("GB", 22);
            this.put("US", 30);
        }
    };
    private static final int CHAR_REST = 55;

    public static boolean checkEGN(String egn) {
        if (egn == null) {
            return false;
        }
        if ((egn = egn.trim()).length() != 10) {
            return false;
        }
        int[] chars = new int[10];
        for (int i = 0; i < 10; ++i) {
            char ch = egn.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            chars[i] = ch - 48;
        }
        int checkSum = (chars[0] * 2 + chars[1] * 4 + chars[2] * 8 + chars[3] * 5 + chars[4] * 10 + chars[5] * 9 + chars[6] * 7 + chars[7] * 3 + chars[8] * 6) % 11;
        if (checkSum == 10) {
            checkSum = 0;
        }
        return chars[9] == checkSum;
    }

    public static boolean checkIBAN(String iban) {
        Integer ibanLength = 0;
        if (iban == null) {
            return false;
        }
        iban = iban.replaceAll(" ", "");
        if ((iban = iban.toUpperCase()).length() > 2 && (ibanLength = ibanLengthMap.get(iban.substring(0, 2))) != null && iban.length() == ibanLength.intValue()) {
            iban = iban.substring(4, iban.length()) + iban.substring(0, 4);
            char[] charArr = iban.toCharArray();
            iban = "";
            for (char aCharArr : charArr) {
                if (Character.isLetter(aCharArr)) {
                    int digit = aCharArr - 55;
                    iban = iban + digit;
                    continue;
                }
                iban = iban + aCharArr;
            }
            BigInteger bi = new BigInteger(iban);
            if ((bi = bi.remainder(new BigInteger("97"))).intValue() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkBulstat(String bulstat) {
        boolean returnValue = false;
        if (bulstat == null) {
            return false;
        }
        if (bulstat.length() == 9 || bulstat.length() == 13) {
            int newSum;
            int rest;
            int lastDigit9 = 0;
            int lastDigit13 = 0;
            char[] charArr = bulstat.toCharArray();
            int sum = 0;
            for (int i = 0; i < 9; ++i) {
                if (Character.isDigit(charArr[i])) {
                    if (i == 8) {
                        lastDigit9 = Integer.parseInt(Character.toString(charArr[i]));
                        rest = sum % 11;
                        if (rest != 10) {
                            if (lastDigit9 != rest) continue;
                            returnValue = true;
                            break;
                        }
                        newSum = 0;
                        for (int j = 0; j < charArr.length - 1; ++j) {
                            int newDigit = Integer.parseInt(Character.toString(charArr[j]));
                            newSum += (j + 3) * newDigit;
                        }
                        int newRest = newSum % 11;
                        if (newRest != 10) {
                            if (lastDigit9 != newRest) continue;
                            returnValue = true;
                            break;
                        }
                        if (lastDigit9 != 0) continue;
                        returnValue = true;
                        break;
                    }
                    int digit = Integer.parseInt(Character.toString(charArr[i]));
                    sum += (i + 1) * digit;
                    continue;
                }
                returnValue = false;
                break;
            }
            if (bulstat.length() == 13) {
                if (!returnValue) {
                    return false;
                }
                sum = 0;
                int digit = 0;
                if (!Character.isDigit(charArr[8])) {
                    return false;
                }
                digit = Integer.parseInt(Character.toString(charArr[8]));
                sum += 2 * digit;
                if (!Character.isDigit(charArr[9])) {
                    return false;
                }
                digit = Integer.parseInt(Character.toString(charArr[9]));
                sum += 7 * digit;
                if (!Character.isDigit(charArr[10])) {
                    return false;
                }
                digit = Integer.parseInt(Character.toString(charArr[10]));
                sum += 3 * digit;
                if (!Character.isDigit(charArr[11])) {
                    return false;
                }
                digit = Integer.parseInt(Character.toString(charArr[11]));
                sum += 5 * digit;
                if (!Character.isDigit(charArr[12])) {
                    return false;
                }
                lastDigit13 = Integer.parseInt(Character.toString(charArr[12]));
                rest = sum % 11;
                if (rest != 10) {
                    if (lastDigit13 == rest) {
                        returnValue = true;
                    }
                } else {
                    newSum = 0;
                    int newDigit = Integer.parseInt(Character.toString(charArr[8]));
                    newSum += 4 * newDigit;
                    newDigit = Integer.parseInt(Character.toString(charArr[9]));
                    newSum += 9 * newDigit;
                    newDigit = Integer.parseInt(Character.toString(charArr[10]));
                    newSum += 5 * newDigit;
                    newDigit = Integer.parseInt(Character.toString(charArr[11]));
                    int newRest = (newSum += 7 * newDigit) % 11;
                    if (newRest != 0) {
                        if (lastDigit13 == newRest) {
                            returnValue = true;
                        }
                    } else if (lastDigit13 == 0) {
                        returnValue = true;
                    }
                }
            }
        }
        return returnValue;
    }
}

