/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.crm.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.HierarchicalItem;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.crm.client.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

@ServerLoader(value="AreaLoaderLocal")
public class AreaDTO
extends HistoryDTO
implements Comparable<AreaDTO>,
HierarchicalItem<AreaDTO, Integer> {
    private String name;
    private String description;
    private static final String PARENT_AREA = "PARENT_AREA";

    public AreaDTO() {
        this.registerProperty(AreaDTO.class, PARENT_AREA, false);
    }

    @Override
    public AreaDTO getParentItem() {
        return (AreaDTO)this.getPropertyValue(PARENT_AREA);
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null || name.trim().length() == 0) {
            throw new PropertyVetoException(Messages.getString("AreaDTO.0"), new PropertyChangeEvent(this, "name", this.name, name));
        }
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String str) {
        this.setModified(this.description, str, "description");
        this.description = str;
    }

    public void setParentId(Integer parentId) {
        this.putObjectValue(PARENT_AREA, parentId);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Integer getParentId() {
        return (Integer)this.getObjectValue(PARENT_AREA);
    }

    @Override
    public int compareTo(AreaDTO object) {
        if (object != null) {
            return this.name.compareTo(object.name);
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getFullName() {
        if (this.getParentId() != null) {
            return this.getParentItem().getFullName() + "\\" + this.name;
        }
        return this.name;
    }
}

