/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.crm.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.framework.util.client.DateUtils;
import com.dsoft.powerpro.crm.client.Messages;
import com.dsoft.powerpro.crm.client.dto.ClientDto;
import com.dsoft.powerpro.crm.client.dto.PhysicalPersonDTO;

@ServerLoader(value="ContractLoaderLocal")
public class ContractDTO
extends HistoryDTO {
    private static final String PERSON = "person";
    private static final String CLIENT = "client";
    private String contractNumber;
    private Long contractDate;

    public ContractDTO() {
        this.registerProperty(ClientDto.class, CLIENT, false);
        this.registerProperty(PhysicalPersonDTO.class, PERSON, true);
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(String contractNumber) {
        this.setModified(this.contractNumber, contractNumber, "contractNumber");
        this.contractNumber = contractNumber;
    }

    public <T extends ClientDto> T getClient() throws DTOFindException {
        return (T)((ClientDto)this.getPropertyValue(CLIENT));
    }

    public Integer getClientId() {
        return (Integer)this.getObjectValue(CLIENT);
    }

    public Long getContractDate() {
        return this.contractDate;
    }

    public void setContractDate(Long contractDate) {
        this.setModified(this.contractDate, contractDate, "contractDate");
        this.contractDate = contractDate;
    }

    public void setClientId(Integer clientId) {
        this.putObjectValue(CLIENT, clientId);
    }

    @Override
    public String toString() {
        return this.contractNumber;
    }

    public String getFullContractNumber() {
        return String.format("%1$s/%2$s", this.contractNumber, this.contractDate != null ? DateUtils.getShortDate(this.contractDate) : Messages.getString("ContractDTO.0"));
    }

    public Integer getPersonId() {
        return (Integer)this.getObjectValue(PERSON);
    }

    public void setPersonId(Integer personId) {
        this.putObjectValue(PERSON, personId);
    }

    public PhysicalPersonDTO getPerson() throws DTOFindException {
        return (PhysicalPersonDTO)this.getPropertyValue(PERSON);
    }

    public void setPerson(PhysicalPersonDTO personDto) {
        if (personDto != null) {
            this.setPersonId(personDto.getId());
        } else {
            this.setPersonId(null);
        }
        this.setProperty(PERSON, this.getPersonId(), personDto);
    }
}

