/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.crm.client.utils;

import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryPK;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.crm.client.dto.ClientDto;
import com.dsoft.powerpro.crm.client.dto.ClientGroupDTO;
import com.dsoft.powerpro.crm.client.dto.OfficialPersonClientDTO;
import java.util.Collection;

public class ClientUtils {
    public static Integer getClientId(Object client) {
        assert (client != null);
        return ((ClientDto)client).getId();
    }

    public static HistoryPK getClientPK(Object client) {
        assert (client != null);
        return ((ClientDto)client).getPk();
    }

    public static String getClientName(Object client) {
        assert (client != null);
        return ((ClientDto)client).getName();
    }

    public static String getClientNumber(Object client) {
        assert (client != null);
        return ((ClientDto)client).getNumber();
    }

    public static Collection<ClientGroupDTO> getClientGroups(Object client) {
        assert (client != null);
        return ((ClientDto)client).getClientGroups();
    }

    public static String getClientPhones(ClientDto client) {
        assert (client != null);
        return client.getPhones() != null ? client.getPhones().replace('\n', ';') : "";
    }

    public static AddressDTO getClientAddress(ClientDto client, boolean registrationAddress) throws DTOFindException {
        assert (client != null);
        if (registrationAddress) {
            return client.getConstAddress();
        }
        return client.getCorespondenceAddressId() != null ? client.getCorespondenceAddress() : client.getConstAddress();
    }

    public static Integer getClientAddressId(ClientDto client, boolean registrationAddress) throws DTOFindException {
        assert (client != null);
        if (registrationAddress) {
            return client.getConstAddressId();
        }
        return client.getCorespondenceAddressId() != null ? client.getCorespondenceAddressId() : client.getConstAddressId();
    }

    public static String getClientMol(ClientDto clientDto) {
        if (clientDto instanceof OfficialPersonClientDTO) {
            return ((OfficialPersonClientDTO)clientDto).getMolName();
        }
        return clientDto.getName();
    }

    public static String getClientMolEGN(ClientDto clientDto) {
        return clientDto.getEgn();
    }

    public static String getClientIdentifier(ClientDto clientDto) {
        if (clientDto instanceof OfficialPersonClientDTO) {
            return ((OfficialPersonClientDTO)clientDto).getBulstat();
        }
        return clientDto.getEgn();
    }

    public static String getClientVatNumber(ClientDto clientDto) {
        if (clientDto instanceof OfficialPersonClientDTO) {
            return ((OfficialPersonClientDTO)clientDto).getVatNo();
        }
        return "BG" + clientDto.getEgn();
    }
}

