/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.exception.DSoftException;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.internet.client.InetHostType;
import com.dsoft.powerpro.internet.client.dto.IPHostDto;
import com.dsoft.powerpro.internet.client.dto.SNMPNetworkDeviceDto;

public abstract class ConfigFileDeviceDto
extends SNMPNetworkDeviceDto {
    private static final String DOUBLE_QUOTES = "\"";
    private static final String FILENAME = "filename";
    protected boolean autoConfigFileName = true;
    protected String configFileName;
    protected boolean immediateRebuild = true;
    protected boolean includeInRebuild = true;

    protected abstract boolean allowDynamicHosts();

    @Override
    public void setHostType(InetHostType hostType) {
        if (InetHostType.DYNAMIC_HOST == hostType && !this.allowDynamicHosts()) {
            super.setHostType(InetHostType.PSEUDO_DYNAMIC_HOST);
        } else {
            super.setHostType(hostType);
        }
    }

    public boolean isAutoConfigFileName() {
        return this.autoConfigFileName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) throws DTOFindException {
        if (this.setModified(this.configFileName, configFileName, "configFileName")) {
            this.configFileName = configFileName;
            if (this.getIpHost() != null) {
                if (configFileName != null) {
                    this.getIpHost().setOptionValue(FILENAME, DOUBLE_QUOTES + this.getConfigFileName() + DOUBLE_QUOTES);
                } else {
                    this.getIpHost().removeOption(FILENAME);
                }
            }
        }
    }

    public void setAutoConfigFileName(boolean autoConfigFileName) {
        this.setModified(autoConfigFileName, autoConfigFileName, "autoConfigFileName");
        this.autoConfigFileName = autoConfigFileName;
    }

    protected IPHostDto getIpHostForConfigFile() throws DSoftException {
        return this.getIpHost();
    }

    protected void updateConfigFileOption(String fileNamePrefix, String extension) throws DSoftException {
        if (this.isAutoConfigFileName()) {
            if (this.getIpHostForConfigFile() != null) {
                IPHostDto hostDto = this.getIpHostForConfigFile();
                if (this.getHostType() == InetHostType.PSEUDO_STATIC_HOST) {
                    this.setConfigFileName(String.format("%1$s%2$s.%3$s", fileNamePrefix, hostDto.getIp(), extension));
                } else if (hostDto.getMac() != null) {
                    String macPart = hostDto.getMac().replaceAll(":", "_").toLowerCase();
                    this.setConfigFileName(String.format("%1$s%2$s.%3$s", fileNamePrefix, macPart, extension));
                } else {
                    this.setConfigFileName(null);
                }
            } else {
                this.setConfigFileName(null);
            }
        }
    }

    public void setImmediateRebuild(boolean immediateRebuild) {
        this.setModified(this.immediateRebuild, immediateRebuild, "immediateRebuild");
        this.immediateRebuild = immediateRebuild;
    }

    public boolean isImmediateRebuild() {
        return this.immediateRebuild;
    }

    public boolean isIncludeInRebuild() {
        return this.includeInRebuild;
    }

    public void setIncludeInRebuild(boolean includeInRebuild) {
        this.setModified(this.includeInRebuild, includeInRebuild, "includeInRebuild");
        this.includeInRebuild = includeInRebuild;
    }
}

