/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOFinderListener;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOListImpl;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.exception.InvalidIPFormatException;
import com.dsoft.framework.client.exception.InvalidMacAddress;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.framework.client.util.InternetUtils;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.internet.client.InetHostType;
import com.dsoft.powerpro.internet.client.dto.InetDHCPOptionDTO;
import com.dsoft.powerpro.internet.client.dto.InetNetworkDTO;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceDto;
import com.dsoft.powerpro.network.client.dto.NetworkSegmentDTO;
import java.util.Collection;

public class IPHostDto
extends IntegerIdDTO
implements Comparable<IPHostDto> {
    private static final String SLASH = "/";
    private static final String EMPTY_STR = "";
    private String serialNumber;
    private Long ipLong;
    private String mac;
    private String hostname;
    private String externalId;
    private InetHostType hostType;
    private DTOList<InetDHCPOptionDTO, Integer> dhcpOptions = new DTOListImpl<InetDHCPOptionDTO, Integer>((Class)InetDHCPOptionDTO.class, (BaseDTO)this, true);
    private static final String NETWORK_DEVICE = "networkDevice";
    private static final String NETWORK = "network";
    private static final String NETWORK_SEGMENT = "networkSegment";

    public NetworkSegmentDTO getNetworkSegment() throws DTOFindException {
        return (NetworkSegmentDTO)this.getPropertyValue(NETWORK_SEGMENT);
    }

    public NetworkDeviceDto getNetworkDevice() throws DTOFindException {
        return (NetworkDeviceDto)this.getPropertyValue(NETWORK_DEVICE);
    }

    public InetNetworkDTO getNetwork() throws DTOFindException {
        return (InetNetworkDTO)this.getPropertyValue(NETWORK);
    }

    public IPHostDto() {
        this.registerProperty(NetworkDeviceDto.class, NETWORK_DEVICE, false);
        this.registerProperty(InetNetworkDTO.class, NETWORK, false);
        this.registerProperty(NetworkSegmentDTO.class, NETWORK_SEGMENT, false);
    }

    public Integer getNetworkId() {
        return (Integer)this.getObjectValue(NETWORK);
    }

    public String getMac() {
        return this.mac;
    }

    public Long getIpLong() {
        return this.ipLong;
    }

    public String getIp() {
        return this.ipLong != null ? IPUtils.ipLongToString(this.ipLong) : null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getDeviceId() {
        return (Integer)this.getObjectValue(NETWORK_DEVICE);
    }

    public Integer getSegmentId() {
        return (Integer)this.getObjectValue(NETWORK_SEGMENT);
    }

    public DTOList<InetDHCPOptionDTO, Integer> getDhcpOptions() {
        return this.dhcpOptions;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public InetHostType getHostType() {
        return this.hostType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setNetworkId(Integer networkId) {
        this.putObjectValue(NETWORK, networkId);
    }

    public void setMac(String mac) throws InvalidMacAddress {
        if (!StringUtil.isEmpty(mac)) {
            mac = InternetUtils.macLongToString(InternetUtils.macStringToLong(mac)).toUpperCase();
        } else if (mac != null) {
            mac = mac.trim();
        }
        this.setModified(this.mac, mac, "mac");
        this.mac = mac;
    }

    public void setIpLong(Long ipLong) {
        this.setModified(this.ipLong, ipLong, "ipLong");
        this.ipLong = ipLong;
    }

    public void setIp(String ip) throws InvalidIPFormatException {
        this.setIpLong(IPUtils.ipStringToLong2(ip));
    }

    public void setHostname(String hostname) {
        this.setModified(this.hostname, hostname, "hostname");
        this.hostname = hostname;
    }

    public void setDeviceId(Integer deviceId) {
        this.putObjectValue(NETWORK_DEVICE, deviceId);
    }

    public void setSegmentId(Integer segmentId) {
        this.putObjectValue(NETWORK_SEGMENT, segmentId);
    }

    public void setExternalId(String externalId) {
        this.setModified(this.externalId, externalId, "externalId");
        this.externalId = externalId;
    }

    public void setHostType(InetHostType hostType) {
        this.setModified((Object)this.hostType, (Object)hostType, "hostType");
        this.hostType = hostType;
    }

    public void setSerialNumber(String serialNumber) {
        this.setModified(this.serialNumber, serialNumber, "serialNumber");
        this.serialNumber = serialNumber;
    }

    public String getOptionValue(String name) throws DTOFindException {
        Collection<InetDHCPOptionDTO> result = this.serachOptionsByName(name);
        if (result.isEmpty() || result.size() > 1) {
            return null;
        }
        InetDHCPOptionDTO optionDto = result.iterator().next();
        return optionDto.getOptionValue();
    }

    private Collection<InetDHCPOptionDTO> serachOptionsByName(final String name) throws DTOFindException {
        return this.dhcpOptions.findElements(new DTOFinderListener<InetDHCPOptionDTO>(){

            @Override
            public boolean isValid(InetDHCPOptionDTO dto) throws DTOFindException {
                return dto.getName().equals(name);
            }
        });
    }

    public Integer getOptionDevice(String name) throws DTOFindException {
        Collection<InetDHCPOptionDTO> result = this.serachOptionsByName(name);
        if (result.isEmpty() || result.size() > 1) {
            return null;
        }
        InetDHCPOptionDTO optionDto = result.iterator().next();
        return optionDto.getLinkedDeviceId();
    }

    public void setOptionValue(String name, String value) throws DTOFindException {
        this.addDhcpOption(name, value, null);
    }

    public void addDhcpOption(String name, String value, Integer deviceId) throws DTOFindException {
        Collection<InetDHCPOptionDTO> result = this.serachOptionsByName(name);
        if (result.isEmpty()) {
            InetDHCPOptionDTO optionDto = new InetDHCPOptionDTO();
            optionDto.setName(name);
            optionDto.setOptionValue(value);
            optionDto.setLinkedDeviceId(deviceId);
            this.dhcpOptions.add(optionDto);
        } else {
            for (InetDHCPOptionDTO optionDto : result) {
                optionDto.setOptionValue(value);
                optionDto.setLinkedDeviceId(deviceId);
            }
        }
    }

    public void removeOption(String name) throws DTOFindException {
        Collection<InetDHCPOptionDTO> result = this.serachOptionsByName(name);
        this.dhcpOptions.removeAll(result);
    }

    @Override
    public String toString() {
        if (this.hostType == null) {
            if (this.getIp() == null && this.getMac() == null) {
                return "Dyamic";
            }
            return (this.getIp() != null ? this.getIp() + SLASH : EMPTY_STR) + (this.getMac() != null ? this.getMac() : EMPTY_STR);
        }
        switch (this.hostType) {
            case DYNAMIC_HOST: {
                return "Dynamic";
            }
            case PSEUDO_DYNAMIC_HOST: {
                return (this.getMac() != null ? this.getMac() : EMPTY_STR) + (this.getHostname() != null ? SLASH + this.getHostname() : EMPTY_STR);
            }
            case PSEUDO_STATIC_HOST: {
                return (this.getIp() != null ? this.getIp() + SLASH : EMPTY_STR) + (this.getMac() != null ? this.getMac() : EMPTY_STR);
            }
            case STATIC_HOST: {
                return (this.getIp() != null ? this.getIp() + SLASH : EMPTY_STR) + (this.getMac() != null ? this.getMac() : EMPTY_STR);
            }
        }
        return EMPTY_STR;
    }

    @Override
    public int compareTo(IPHostDto that) {
        return this.ipLong != null ? (that.ipLong != null ? this.ipLong.compareTo(that.ipLong) : 1) : (that.ipLong != null ? -1 : 0);
    }

    public String getAddress() {
        return this.hostname != null && this.hostname.trim().length() > 0 ? this.hostname : this.getIp();
    }
}

