/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.powerpro.internet.client.InetHostType;
import com.dsoft.powerpro.internet.client.dto.IPHostDto;
import com.dsoft.powerpro.network.client.dto.NetDeviceRowsDto;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceDto;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IPNetworkDeviceDto
extends NetworkDeviceDto {
    private Map<NetDeviceRowsDto, IPHostDto> ipHostMap = new HashMap<NetDeviceRowsDto, IPHostDto>();
    private InetHostType hostType;
    private Set<IPHostDto> hostSet = new HashSet<IPHostDto>();
    private boolean useHostNameAsDeviceName = true;

    public IPNetworkDeviceDto() {
        this.setHostType(InetHostType.PSEUDO_DYNAMIC_HOST);
    }

    public Map<NetDeviceRowsDto, IPHostDto> getIPHostsCopy() {
        return new HashMap<NetDeviceRowsDto, IPHostDto>(this.ipHostMap);
    }

    public IPHostDto getIPHost(NetDeviceRowsDto devRowsInfo) {
        return this.ipHostMap.get(devRowsInfo);
    }

    public void addIPHost(NetDeviceRowsDto devRowsInfo, IPHostDto ipHostDto) {
        ipHostDto.setHostType(this.hostType);
        if (this.hostSet.contains(ipHostDto)) {
            this.updateIPHostMap(devRowsInfo, ipHostDto);
        } else {
            ipHostDto.setParent(this);
            ipHostDto.setDeviceId(this.getId());
            this.ipHostMap.put(devRowsInfo, ipHostDto);
            this.hostSet.add(ipHostDto);
            this.setModified("ipHosts");
        }
    }

    public void removeIPHost(NetDeviceRowsDto devRowsInfo) {
        if (this.ipHostMap.containsKey(devRowsInfo)) {
            IPHostDto ipHostDto = this.ipHostMap.remove(devRowsInfo);
            this.cleanupIPHostDto(ipHostDto);
        }
    }

    private void cleanupIPHostDto(IPHostDto ipHostDto) {
        ipHostDto.setDeviceId(null);
        ipHostDto.setParent(null);
        this.setModified("ipHosts");
        if (!this.searchForIPHost(ipHostDto)) {
            this.hostSet.remove(ipHostDto);
        }
    }

    public void replaceIPHost(NetDeviceRowsDto devRowsInfo, IPHostDto newDto) {
        if (this.ipHostMap.containsKey(devRowsInfo)) {
            IPHostDto originalDto = this.ipHostMap.get(devRowsInfo);
            this.addIPHost(devRowsInfo, newDto);
            this.cleanupIPHostDto(originalDto);
        }
    }

    private boolean searchForIPHost(IPHostDto originalDto) {
        for (IPHostDto hostDto : this.ipHostMap.values()) {
            if (!hostDto.equals(originalDto)) continue;
            return true;
        }
        return false;
    }

    private void updateIPHostMap(NetDeviceRowsDto devRowsInfo, IPHostDto newIpHostDto) {
        for (IPHostDto iph : this.hostSet) {
            iph.setParent(this);
            if (!iph.equals(newIpHostDto)) continue;
            this.ipHostMap.put(devRowsInfo, iph);
            break;
        }
    }

    @Override
    public Object getDeviceParameters(NetDeviceRowsDto deviceRowDto) {
        return this.ipHostMap.get(deviceRowDto);
    }

    public Object getDeviceParameters() {
        return this.ipHostMap.get(this.getSelectedConfiguration());
    }

    public boolean isUseHostNameAsDeviceName() {
        return this.useHostNameAsDeviceName;
    }

    public InetHostType getHostType() {
        return this.hostType;
    }

    public IPHostDto getIpHost() {
        if (this.ipHostMap.containsKey(this.getSelectedConfiguration())) {
            return this.ipHostMap.get(this.getSelectedConfiguration());
        }
        return null;
    }

    public void setUseHostNameAsDeviceName(boolean value) {
        this.setModified(value, this.useHostNameAsDeviceName, "useHostNameAsDeviceName");
        this.useHostNameAsDeviceName = value;
    }

    public void setHostType(InetHostType hostType) {
        this.setModified((Object)this.hostType, (Object)hostType, "hostType");
        this.hostType = hostType;
    }

    public void selectActiveConfiguration() {
        for (NetDeviceRowsDto devRowDto : this.getDeviceRowsList()) {
            if (devRowDto.isExtension() || !devRowDto.isValid()) continue;
            this.setSelectedConfiguration(devRowDto.getRowIdentifier(), devRowDto.getServiceId());
            return;
        }
        for (NetDeviceRowsDto devRowDto : this.getDeviceRowsList()) {
            if (devRowDto.isExtension() || !devRowDto.hasIntervalAfter(System.currentTimeMillis())) continue;
            this.setSelectedConfiguration(devRowDto.getRowIdentifier(), devRowDto.getServiceId());
            return;
        }
        for (NetDeviceRowsDto devRowDto : this.getDeviceRowsList()) {
            if (devRowDto.isExtension() || devRowDto.getCurrentInterval() == null) continue;
            this.setSelectedConfiguration(devRowDto.getRowIdentifier(), devRowDto.getServiceId());
            return;
        }
    }
}

