/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.base.HierarchicalItem;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.internet.client.dto.MibUnitDto;
import java.util.Collection;
import java.util.HashSet;

@ServerLoader(value="InetMibobjecttreeLoaderLocal")
public class InetMibObjectTreeDTO
extends IntegerIdDTO
implements HierarchicalItem<InetMibObjectTreeDTO, Integer>,
Comparable<InetMibObjectTreeDTO> {
    private static final Collection<Integer> EMPTY_SET = new HashSet<Integer>();
    private DTOSet<MibUnitDto, Integer> mibUnits = new DTOSet(MibUnitDto.class, this, false);
    private String status;
    private String access;
    private String syntax;
    private String defaultValue;
    private String description;
    private String oidStr;
    private String name;
    private Integer oidType;
    private static final String PARENT_MIB_OBJECT = "PARENT_MIB_OBJECT";

    public InetMibObjectTreeDTO() {
        this.registerProperty(InetMibObjectTreeDTO.class, PARENT_MIB_OBJECT, false);
    }

    public DTOSet<MibUnitDto, Integer> getMibUnits() {
        return this.mibUnits;
    }

    public Integer getParentId() {
        return (Integer)this.getObjectValue(PARENT_MIB_OBJECT);
    }

    @Override
    public InetMibObjectTreeDTO getParentItem() {
        return (InetMibObjectTreeDTO)this.getPropertyValue(PARENT_MIB_OBJECT);
    }

    public void setParentId(Integer parentId) {
        this.putObjectValue(PARENT_MIB_OBJECT, parentId);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.setModified(this.status, status, "status");
        this.status = status;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.setModified(this.access, access, "access");
        this.access = access;
    }

    public String getSyntax() {
        return this.syntax;
    }

    private String getSyntaxText(Collection<Integer> mUnits) {
        Collection<Integer> parentUnits;
        Collection<Integer> collection = parentUnits = this.getParentItem() != null ? this.getParentItem().getMibUnits().getAllId() : EMPTY_SET;
        return StringUtil.isEmpty(this.syntax) ? (this.getParentItem() != null && (mUnits.isEmpty() || parentUnits.equals(mUnits)) ? this.getParentItem().getSyntaxText(mUnits) : this.syntax) : this.syntax;
    }

    public String getSyntaxText() {
        return StringUtil.isEmpty(this.syntax) ? this.getSyntaxText(this.mibUnits.getAllId()) : this.syntax;
    }

    public void setSyntax(String syntax) {
        this.setModified(this.syntax, syntax, "syntax");
        this.syntax = syntax;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.setModified(this.defaultValue, defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.setModified(this.description, description, "description");
        this.description = description;
    }

    public String getOidStr() {
        return this.oidStr;
    }

    public void setOidStr(String oidStr) {
        this.setModified(this.oidStr, oidStr, "oidStr");
        this.oidStr = oidStr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public Integer getOidType() {
        return this.oidType;
    }

    public void setOidType(Integer oidType) {
        this.setModified(this.oidType, oidType, "oidType");
        this.oidType = oidType;
    }

    @Override
    public String toString() {
        return "[parent:" + this.getParentId() + "status:" + this.status + "access:" + this.access + "syntax:" + this.syntax + "defaultValue:" + this.defaultValue + "description:" + this.description + "oidStr:" + this.oidStr + "name:" + this.name + "oidType:" + this.oidType + "]";
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int compareTo(InetMibObjectTreeDTO o) {
        String oid1 = this.oidStr;
        String oid2 = o.getOidStr();
        String[] oid1Parts = oid1.split("\\.");
        String[] oid2Parts = oid2.split("\\.");
        int minLength = Math.min(oid1Parts.length, oid2Parts.length);
        for (int i = 0; i < minLength; ++i) {
            if (oid1Parts[i].equals(oid2Parts[i])) continue;
            return new Integer(Integer.parseInt(oid1Parts[i])).compareTo(Integer.parseInt(oid2Parts[i]));
        }
        return Integer.compare(oid2.length(), oid1.length());
    }

    private String getDescriptionText(Collection<Integer> mUnits) {
        Collection<Integer> parentUnits;
        Collection<Integer> collection = parentUnits = this.getParentItem() != null ? this.getParentItem().getMibUnits().getAllId() : EMPTY_SET;
        return StringUtil.isEmpty(this.description) ? (this.getParentItem() != null && (mUnits.isEmpty() || parentUnits.equals(mUnits)) ? this.getParentItem().getDescriptionText(mUnits) : this.description) : this.description;
    }

    public String getDescriptionText() {
        return StringUtil.isEmpty(this.description) ? this.getDescriptionText(this.mibUnits.getAllId()) : this.description;
    }
}

