/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOListImpl;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.internet.client.dto.InetDDNSForwardZoneDTO;
import com.dsoft.powerpro.internet.client.dto.InetDHCPOptionDTO;
import com.dsoft.powerpro.internet.client.dto.InetNetworkRangesDTO;
import com.dsoft.powerpro.internet.client.dto.InetProvisioningServerDTO;
import com.dsoft.powerpro.network.client.dto.NetworkSegmentDTO;

@ServerLoader(value="InetNetworkLoaderLocal")
public class InetNetworkDTO
extends NetworkSegmentDTO {
    private static final String DDNS_ZONE = "ddnsZone";
    private static final String INET_PROVISIONING_SERVER_D_T_O = "InetProvisioningServerDTO";
    private Long networkAddress;
    private Long networkMask;
    private String lockedFor;
    private Long ddnsServerAddress;
    private DTOList<InetDHCPOptionDTO, Integer> netDHCPOptions = new DTOListImpl<InetDHCPOptionDTO, Integer>((Class)InetDHCPOptionDTO.class, (BaseDTO)this, true);
    private DTOList<InetNetworkRangesDTO, Integer> addressPools = new DTOListImpl<InetNetworkRangesDTO, Integer>((Class)InetNetworkRangesDTO.class, (BaseDTO)this, true);
    private int maskBits;

    public InetNetworkDTO() {
        this.registerProperty(InetProvisioningServerDTO.class, INET_PROVISIONING_SERVER_D_T_O, false);
        this.registerProperty(InetDDNSForwardZoneDTO.class, DDNS_ZONE, false);
        this.setSegmentType(NETWORK_SEGMENT_LEAYER_3);
    }

    @Override
    public Integer getSegmentType() {
        return NETWORK_SEGMENT_LEAYER_3;
    }

    public Long getNetworkAddress() {
        return this.networkAddress;
    }

    public void setNetworkAddress(Long networkAddress) {
        this.setModified(this.networkAddress, networkAddress);
        this.networkAddress = networkAddress;
        if (networkAddress != null && this.networkMask != null) {
            this.maskBits = IPUtils.calculateMaskFields(networkAddress, this.networkMask);
        }
    }

    public String getNetworkAddressAsString() {
        return IPUtils.ipLongToString(this.networkAddress);
    }

    public String getNetworkMaskAsString() {
        return IPUtils.ipLongToString(this.networkMask);
    }

    public Long getNetworkMask() {
        return this.networkMask;
    }

    public void setNetworkMask(Long networkMask) {
        this.setModified(this.networkMask, networkMask);
        this.networkMask = networkMask;
        if (this.networkAddress != null && networkMask != null) {
            this.maskBits = IPUtils.calculateMaskFields(this.networkAddress, networkMask);
        }
    }

    public String getLockedFor() {
        return this.lockedFor;
    }

    public void setLockedFor(String lockedFor) {
        this.setModified(this.lockedFor, lockedFor);
        this.lockedFor = lockedFor;
    }

    public Integer getProvServerId() {
        return (Integer)this.getObjectValue(INET_PROVISIONING_SERVER_D_T_O);
    }

    public void setProvServerId(Integer provServerId) {
        this.putObjectValue(INET_PROVISIONING_SERVER_D_T_O, provServerId);
    }

    public InetDDNSForwardZoneDTO getDDNSZone() throws DTOFindException {
        return (InetDDNSForwardZoneDTO)this.getPropertyValue(DDNS_ZONE);
    }

    public void setDdnsZoneId(Integer ddnsZoneId) {
        this.putObjectValue(DDNS_ZONE, ddnsZoneId);
    }

    public void setDdnsServerAddress(Long ddnsServerAddress) {
        this.setModified(this.ddnsServerAddress, ddnsServerAddress);
        this.ddnsServerAddress = ddnsServerAddress;
    }

    public DTOList<InetDHCPOptionDTO, Integer> getNetDHCPOptions() {
        return this.netDHCPOptions;
    }

    public InetProvisioningServerDTO getInetProvisioningServer() throws DTOFindException {
        return (InetProvisioningServerDTO)this.getPropertyValue(INET_PROVISIONING_SERVER_D_T_O);
    }

    public DTOList<InetNetworkRangesDTO, Integer> getAddressPools() {
        return this.addressPools;
    }

    public Integer getDdnsZoneId() {
        return (Integer)this.getObjectValue(DDNS_ZONE);
    }

    public Long getDdnsServerAddress() {
        return this.ddnsServerAddress;
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public boolean isIpFromNetwork(String ip) throws Exception {
        long ipi = IPUtils.ipStringToLong(ip);
        long realNetMask = this.getNetworkMask();
        long netAddress = this.getNetworkAddress() & realNetMask;
        long i = realNetMask;
        long j = 0L;
        while (i % 2L == 0L) {
            j = j * 2L + 1L;
            i /= 2L;
        }
        long broadcast = j | netAddress;
        return netAddress <= ipi && broadcast >= ipi;
    }
}

