/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOListImpl;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.internet.client.InetServiceType;
import com.dsoft.powerpro.internet.client.dto.InetDHCPDeviceClassDTO;
import com.dsoft.powerpro.internet.client.dto.InetNetworkRangesDTO;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceServiceMeta;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceTypeRegisterDTO;
import java.util.HashSet;
import java.util.Set;

public class InternetOperationMetaDTO
extends NetworkDeviceServiceMeta {
    private static final String RESERVED_D_H_C_P_CLASS = "reservedDHCPClass";
    private static final String DYNAMIC_D_H_C_P_CLASS = "dynamicDHCPClass";
    private static final String DEFAULT_DEVICE_TYPE = "DEFAULT_DEVICE_TYPE";
    private DTOList<InetNetworkRangesDTO, Integer> networkRanges = new DTOListImpl<InetNetworkRangesDTO, Integer>((Class)InetNetworkRangesDTO.class, (BaseDTO)this);
    private Set<Integer> activeRanges = new HashSet<Integer>();
    private int maxHostsPerService;
    private String serviceIdentifier;
    private String inactiveServiceIdentifier;
    private boolean externalProvisioning;
    private InetServiceType inetType;
    private int servicePrio;
    private Integer validHostTypeSet;
    private DTOList<NetworkDeviceTypeRegisterDTO, Integer> validDeviceTypes = new DTOListImpl<NetworkDeviceTypeRegisterDTO, Integer>((Class)NetworkDeviceTypeRegisterDTO.class);
    private DTOList<InetDHCPDeviceClassDTO, Integer> validDhcpClasses = new DTOListImpl<InetDHCPDeviceClassDTO, Integer>((Class)InetDHCPDeviceClassDTO.class);
    private Set<String> validDeviceTypesSet;

    public InternetOperationMetaDTO() {
        this.registerProperty(InetDHCPDeviceClassDTO.class, DYNAMIC_D_H_C_P_CLASS, false);
        this.registerProperty(InetDHCPDeviceClassDTO.class, RESERVED_D_H_C_P_CLASS, false);
        this.registerProperty(NetworkDeviceTypeRegisterDTO.class, DEFAULT_DEVICE_TYPE, false);
    }

    public Integer getDefaultDeviceTypeId() {
        return (Integer)this.getObjectValue(DEFAULT_DEVICE_TYPE);
    }

    public void setDefaultDeviceTypeId(Integer id) {
        this.putObjectValue(DEFAULT_DEVICE_TYPE, id);
    }

    public NetworkDeviceTypeRegisterDTO getDefaultDeviceType() {
        return (NetworkDeviceTypeRegisterDTO)this.getPropertyValue(DEFAULT_DEVICE_TYPE);
    }

    public DTOList<NetworkDeviceTypeRegisterDTO, Integer> getValidDeviceTypes() {
        return this.validDeviceTypes;
    }

    public Set<Integer> getActiveRanges() {
        return this.activeRanges;
    }

    public InetDHCPDeviceClassDTO getDynamicDHCPClass() throws DTOFindException {
        return (InetDHCPDeviceClassDTO)this.getPropertyValue(DYNAMIC_D_H_C_P_CLASS);
    }

    public Integer getDynamicDhcpClassId() {
        return (Integer)this.getObjectValue(DYNAMIC_D_H_C_P_CLASS);
    }

    public void setDynamicDhcpClassId(Integer dynamicDhcpClassId) {
        this.putObjectValue(DYNAMIC_D_H_C_P_CLASS, dynamicDhcpClassId);
    }

    public String getInactiveServiceIdentifier() {
        return this.inactiveServiceIdentifier;
    }

    public void setInactiveServiceIdentifier(String inactiveServiceIdentifier) {
        this.setModified(this.inactiveServiceIdentifier, inactiveServiceIdentifier);
        this.inactiveServiceIdentifier = inactiveServiceIdentifier;
    }

    public InetServiceType getInetType() {
        return this.inetType;
    }

    public void setInetType(InetServiceType inetType) {
        this.setModified((Object)this.inetType, (Object)inetType);
        this.inetType = inetType;
    }

    public int getMaxHostsPerService() {
        return this.maxHostsPerService;
    }

    public void setMaxHostsPerService(int maxHostsPerService) {
        this.setModified(this.maxHostsPerService, maxHostsPerService);
        this.maxHostsPerService = maxHostsPerService;
    }

    public DTOList<InetNetworkRangesDTO, Integer> getNetworkRanges() {
        return this.networkRanges;
    }

    public InetDHCPDeviceClassDTO getReservedDHCPClass() throws DTOFindException {
        return (InetDHCPDeviceClassDTO)this.getPropertyValue(RESERVED_D_H_C_P_CLASS);
    }

    public Integer getReservedDhcpClassId() {
        return (Integer)this.getObjectValue(RESERVED_D_H_C_P_CLASS);
    }

    public void setReservedDhcpClassId(Integer reservedDhcpClassId) {
        this.putObjectValue(RESERVED_D_H_C_P_CLASS, reservedDhcpClassId);
    }

    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public void setServiceIdentifier(String serviceIdentifier) {
        this.setModified(this.serviceIdentifier, serviceIdentifier);
        this.serviceIdentifier = serviceIdentifier;
    }

    public int getServicePrio() {
        return this.servicePrio;
    }

    public void setServicePrio(int servicePrio) {
        this.setModified(this.servicePrio, servicePrio);
        this.servicePrio = servicePrio;
    }

    public DTOList<InetDHCPDeviceClassDTO, Integer> getValidDhcpClasses() {
        return this.validDhcpClasses;
    }

    public boolean isExternalProvisioning() {
        return this.externalProvisioning;
    }

    public void setExternalProvisioning(boolean externalProvisioning) {
        this.setModified(this.externalProvisioning, externalProvisioning);
        this.externalProvisioning = externalProvisioning;
    }

    public Integer getValidHostTypeSet() {
        return this.validHostTypeSet;
    }

    public void setValidHostTypeSet(Integer validHostTypeSet) {
        this.setModified(this.validHostTypeSet, validHostTypeSet);
        this.validHostTypeSet = validHostTypeSet;
    }

    public boolean isSupportDeviceType(String deviceTypeClass) {
        if (this.validDeviceTypesSet == null) {
            this.validDeviceTypesSet = new HashSet<String>();
            for (NetworkDeviceTypeRegisterDTO deviceTypeRegisterDTO : this.validDeviceTypes) {
                this.validDeviceTypesSet.add(deviceTypeRegisterDTO.getDeviceTypeClass());
            }
        }
        return this.validDeviceTypesSet.contains(deviceTypeClass);
    }
}

