/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.client.dto;

import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.internet.client.dto.InetMibObjectTreeDTO;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceDto;

public class SNMPValueDTO
extends IntegerIdDTO {
    private static final String MIB_OBJECT = "mibObject";
    private static final String LINKED_DEVICE = "LINKED_DEVICE";
    private String value;
    private String oidIndex;
    private String mibObjectIdString;
    private String syntax;

    public SNMPValueDTO() {
        this.registerProperty(InetMibObjectTreeDTO.class, MIB_OBJECT, false);
        this.registerProperty(NetworkDeviceDto.class, LINKED_DEVICE, false);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.setModified(this.value, value, "value");
        this.value = value;
    }

    public InetMibObjectTreeDTO getMIBObject() throws DTOFindException {
        return (InetMibObjectTreeDTO)this.getPropertyValue(MIB_OBJECT);
    }

    public String getOidIndex() {
        return this.oidIndex;
    }

    public Integer getLinkedToDevice() {
        return (Integer)this.getObjectValue(LINKED_DEVICE);
    }

    public Integer getMibObjectId() {
        return (Integer)this.getObjectValue(MIB_OBJECT);
    }

    public String getMibObjectIdString() {
        return this.mibObjectIdString;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setOidIndex(String oidIndex) {
        this.setModified(this.oidIndex, oidIndex, "oidIndex");
        this.oidIndex = oidIndex;
    }

    public void setLinkedToDevice(Integer linkedToDevice) {
        this.putObjectValue(LINKED_DEVICE, linkedToDevice);
    }

    public void setMibObjectId(Integer mibObjectId) {
        this.putObjectValue(MIB_OBJECT, mibObjectId);
    }

    public void setMibObjectIdString(String mibObjectIdString) {
        this.setModified(this.mibObjectIdString, mibObjectIdString, "mibObjectIdString");
        this.mibObjectIdString = mibObjectIdString;
    }

    public void setSyntax(String Syntax) {
        this.setModified(this.syntax, Syntax, "syntax");
        this.syntax = Syntax;
    }

    public String getFullOID() throws DTOFindException {
        String s = null;
        s = this.getMibObjectId() != null ? this.getMIBObject().getOidStr() : this.mibObjectIdString;
        if (StringUtil.isEmpty(this.oidIndex)) {
            return s;
        }
        if (!s.endsWith(".")) {
            s = s + ".";
        }
        return s + this.oidIndex;
    }

    @Override
    public String toString() {
        return this.oidIndex + ", " + this.value;
    }
}

