/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.serial.io.JBossObjectInputStream;

public class BaseThread
extends Thread {
    private static final Logger logger = Logger.getLogger(BaseThread.class.getName());
    private static final int ONE_MINUTE = 60000;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private static final long TEN_SECONDS = 10000L;

    protected BaseThread(String name, InputStream inputStrem) {
        super(name);
        this.inputStream = inputStrem;
        this.outputStream = null;
    }

    protected BaseThread(String name, OutputStream outputStream) {
        super(name);
        this.outputStream = outputStream;
        this.inputStream = null;
    }

    private boolean fillBuffer(byte[] buffer, long timeOut) throws IOException {
        int pos;
        int len;
        long startTime = System.currentTimeMillis();
        for (pos = 0; pos < buffer.length && System.currentTimeMillis() - startTime < timeOut; pos += len) {
            len = this.inputStream.read(buffer, pos, buffer.length - pos);
            if (len > 0) {
                startTime = System.currentTimeMillis();
                continue;
            }
            throw new IOException("Socket is closed");
        }
        if (pos != buffer.length) {
            System.out.println(pos + ":" + buffer.length);
            return false;
        }
        return true;
    }

    protected boolean checkForMore() throws IOException {
        if (this.inputStream == null) {
            return false;
        }
        int data = this.inputStream.read();
        if (data < 0) {
            throw new IOException("Socket is closed");
        }
        return data == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readObject() throws IOException {
        block11: {
            byte[] buffer;
            block12: {
                long start;
                block10: {
                    Object object;
                    if (this.inputStream == null) {
                        return null;
                    }
                    buffer = new byte[4];
                    if (!this.fillBuffer(buffer, 10000L)) {
                        logger.log(Level.SEVERE, "Unable to read packet length");
                        return null;
                    }
                    int len = BaseThread.byteToInt(buffer);
                    buffer = new byte[len];
                    boolean isString = this.inputStream.read() == 1;
                    boolean readResult = this.fillBuffer(buffer, 10000L);
                    if (!readResult) break block11;
                    if (isString) break block12;
                    start = System.currentTimeMillis();
                    try {
                        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                        JBossObjectInputStream ois = new JBossObjectInputStream(is);
                        Object object2 = null;
                        try {
                            object2 = ois.readObject();
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.log(Level.SEVERE, cnfe.getMessage(), cnfe);
                        }
                        finally {
                            ois.close();
                        }
                        if (object2 == null) break block10;
                        object = object2;
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.FINE, String.format("Total time to decode %1$d bytes: %2$dms(%3$s)", buffer.length, System.currentTimeMillis() - start, Thread.currentThread().getName()));
                        throw throwable;
                    }
                    logger.log(Level.FINE, String.format("Total time to decode %1$d bytes: %2$dms(%3$s)", buffer.length, System.currentTimeMillis() - start, Thread.currentThread().getName()));
                    return object;
                }
                logger.log(Level.FINE, String.format("Total time to decode %1$d bytes: %2$dms(%3$s)", buffer.length, System.currentTimeMillis() - start, Thread.currentThread().getName()));
                break block11;
            }
            return new String(buffer, "utf-8");
        }
        System.out.println("Invalid read");
        return null;
    }

    private String getLast16Bytes(byte[] buffer) {
        int pos;
        StringBuilder builder = new StringBuilder();
        int n = pos = buffer.length > 16 ? buffer.length - 16 : 0;
        while (pos < buffer.length) {
            builder.append(String.format("%1$x", buffer[pos])).append(", ");
            ++pos;
        }
        return builder.toString();
    }

    public static int byteToInt(byte[] value) {
        return value[3] & 0xFF | (value[2] & 0xFF) << 8 | (value[1] & 0xFF) << 16 | (value[0] & 0xFF) << 24;
    }

    public static byte[] intToByte(int value) {
        byte[] len = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeData(byte[] buffer, boolean isString, boolean hasMore) throws IOException, InterruptedException {
        if (this.outputStream == null || buffer == null) {
            return;
        }
        byte[] len = BaseThread.intToByte(buffer.length);
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(len);
            this.outputStream.write(isString ? 1 : 0);
            this.outputStream.write(buffer);
            this.outputStream.write(hasMore ? 1 : 0);
        }
    }
}

