/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.serial.io.JBossObjectOutputStream;

public abstract class MessageQueue {
    private static final Logger logger = Logger.getLogger(MessageQueue.class.getName());
    private static MessageQueue messageQueue;
    private final Map<Integer, ReceiverQueue> queueMap = new HashMap<Integer, ReceiverQueue>();
    private final List<PersistenceTask> persistenceTasks = new ArrayList<PersistenceTask>();
    private boolean closed = true;
    private Thread persistenceThread;
    private static final long _32MB = 0x2000000L;

    public static MessageQueue getMessageQueue() {
        return messageQueue;
    }

    protected MessageQueue() {
        messageQueue = this;
        this.closed = true;
        this.persistenceThread = new PersistenceThread();
        this.persistenceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueObject popMessage(Integer receiverId, boolean onlyHighPriority) throws InterruptedException {
        if (this.closed) {
            return null;
        }
        if (receiverId == null) {
            receiverId = 0;
        }
        QueueObject result = null;
        Map<Integer, ReceiverQueue> map = this.queueMap;
        synchronized (map) {
            ReceiverQueue receiverQueue;
            while ((receiverQueue = this.queueMap.get(receiverId)) != null && !receiverQueue.isEmpty()) {
                result = receiverQueue.next();
                if (onlyHighPriority && result.isValid() && result.getPriority() == 0) {
                    return null;
                }
                receiverQueue.removeFromQueue(result);
                if (!result.isValid()) {
                    this.invoke(this.getDeleteJob(result.getId()));
                    result = null;
                    continue;
                }
                if (result.getSerializedObject() != null) break;
                this.invokeAndWait(this.getLoadJob(result));
                break;
            }
        }
        return result;
    }

    protected abstract PersistenceTask getLoadJob(QueueObject var1);

    protected abstract PersistenceTask getDeleteJob(Long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHigPriorityMessages(Integer receiverId) {
        if (receiverId == null) {
            receiverId = 0;
        }
        Map<Integer, ReceiverQueue> map = this.queueMap;
        synchronized (map) {
            ReceiverQueue receiverQueue = this.queueMap.get(receiverId);
            return receiverQueue != null && !receiverQueue.priorityQueue.isEmpty();
        }
    }

    public Collection<QueueObject> popHighPriorityMessages(Integer receiverId) throws InterruptedException {
        return this.popMessages(receiverId, true, 0);
    }

    public Collection<QueueObject> popMessages(Integer receiverId, int maxMessagesToPop) throws InterruptedException {
        return this.popMessages(receiverId, false, maxMessagesToPop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<QueueObject> popMessages(Integer receiverId, boolean onlyHighPriority, int maxMessagesToPop) throws InterruptedException {
        if (receiverId == null) {
            receiverId = 0;
        }
        ArrayList<QueueObject> result = new ArrayList<QueueObject>();
        if (this.closed) {
            return result;
        }
        Map<Integer, ReceiverQueue> map = this.queueMap;
        synchronized (map) {
            ReceiverQueue receiverQueue = this.queueMap.get(receiverId);
            if (receiverQueue == null) {
                return result;
            }
            while (!receiverQueue.isEmpty() && (result.size() < maxMessagesToPop || onlyHighPriority)) {
                QueueObject object = receiverQueue.next();
                if (onlyHighPriority && object.getPriority() == 0) break;
                receiverQueue.removeFromQueue(object);
                if (!object.isValid()) {
                    this.invoke(this.getDeleteJob(object.getId()));
                    continue;
                }
                if (object.getSerializedObject() == null) {
                    this.invokeAndWait(this.getLoadJob(object));
                }
                result.add(object);
            }
        }
        return result;
    }

    public void confirmMessage(Long messageId) throws Exception {
        this.invokeAndWait(this.getDeleteJob(messageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndWait(PersistenceTask job) throws InterruptedException {
        PersistenceTask persistenceTask = job;
        synchronized (persistenceTask) {
            List<PersistenceTask> list = this.persistenceTasks;
            synchronized (list) {
                this.persistenceTasks.add(job);
                this.persistenceTasks.notify();
            }
            job.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(PersistenceTask job) throws InterruptedException {
        PersistenceTask persistenceTask = job;
        synchronized (persistenceTask) {
            List<PersistenceTask> list = this.persistenceTasks;
            synchronized (list) {
                this.persistenceTasks.add(job);
                this.persistenceTasks.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessage(Object message, Integer priority, long timeOut, Integer receiverId, boolean persist) throws Exception {
        if (this.closed) {
            return;
        }
        ByteArrayOutputStream baou = new ByteArrayOutputStream();
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            JBossObjectOutputStream oos = new JBossObjectOutputStream(baou);
            try {
                oos.writeObject(message);
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        byte[] serializedObject = baou.toByteArray();
        if (receiverId == null) {
            receiverId = 0;
        }
        timeOut = timeOut < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeOut * 1000L;
        QueueObject queueObject = new QueueObject(serializedObject, priority, timeOut, receiverId, persist);
        if (persist) {
            this.invokeAndWait(this.getInsertJob(queueObject));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Posting message of type %1$s to queue for receiver %2$d", message.getClass().getSimpleName(), receiverId));
        }
        queueObject = this.appendMessage(queueObject, receiverId);
    }

    protected abstract PersistenceTask getInsertJob(QueueObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueObject appendMessage(QueueObject queueObject, Integer receiverId) {
        Map<Integer, ReceiverQueue> map = this.queueMap;
        synchronized (map) {
            ReceiverQueue receiverQueue = this.getReceiverQueue(receiverId);
            receiverQueue.putQueueObject(queueObject);
            return queueObject;
        }
    }

    protected void appendMessage(Long id, byte[] serializedObject, Integer priority, Integer receiverId, long expires, boolean persisted) {
        this.appendMessage(new QueueObject(id, serializedObject, priority, expires, receiverId, persisted), receiverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBackToQueue(QueueObject object, Integer receiverId) {
        Map<Integer, ReceiverQueue> map = this.queueMap;
        synchronized (map) {
            ReceiverQueue receiverQueue = this.getReceiverQueue(receiverId);
            receiverQueue.putQueueObject(object);
        }
    }

    private ReceiverQueue getReceiverQueue(Integer receiverId) {
        ReceiverQueue receiverQueue = this.queueMap.get(receiverId);
        if (receiverQueue == null) {
            receiverQueue = new ReceiverQueue();
            this.queueMap.put(receiverId, receiverQueue);
        }
        return receiverQueue;
    }

    public void close() {
        this.closed = true;
        this.persistenceThread.interrupt();
    }

    protected void initializeQueue() throws Exception {
        this.closed = false;
    }

    class PersistenceThread
    extends Thread {
        PersistenceThread() {
            super(new ThreadGroup("Monitor messaging"), "Persistence thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                List list;
                Object task = null;
                try {
                    list = MessageQueue.this.persistenceTasks;
                    synchronized (list) {
                        if (MessageQueue.this.persistenceTasks.isEmpty()) {
                            MessageQueue.this.persistenceTasks.wait();
                        }
                        task = (PersistenceTask)MessageQueue.this.persistenceTasks.remove(0);
                    }
                    task.run();
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (task == null) continue;
                list = task;
                synchronized (list) {
                    task.notify();
                }
            }
        }
    }

    public static interface PersistenceTask {
        public void run() throws Exception;
    }

    class ReceiverQueue {
        List<QueueObject> normalQueue = new ArrayList<QueueObject>();
        long normalQueueLength = 0L;
        TreeSet<QueueObject> priorityQueue = new TreeSet();

        ReceiverQueue() {
        }

        void putQueueObject(QueueObject queueObject) {
            if (queueObject.getPriority() == 0) {
                this.normalQueue.add(queueObject);
                if (queueObject.getSerializedObject() != null) {
                    if ((long)queueObject.getSerializedObject().length + this.normalQueueLength < 0x2000000L) {
                        this.normalQueueLength += (long)queueObject.getSerializedObject().length;
                    } else if (queueObject.isPersisted()) {
                        queueObject.serializedObject = null;
                    }
                }
            } else {
                this.priorityQueue.add(queueObject);
            }
        }

        public boolean isEmpty() {
            return this.normalQueue.isEmpty() && this.priorityQueue.isEmpty();
        }

        public QueueObject next() {
            if (!this.priorityQueue.isEmpty()) {
                return this.priorityQueue.first();
            }
            return this.normalQueue.get(0);
        }

        void removeFromQueue(QueueObject queueObject) {
            if (queueObject.getPriority() == 0) {
                this.normalQueue.remove(queueObject);
                if (queueObject.getSerializedObject() != null) {
                    this.normalQueueLength -= (long)queueObject.getSerializedObject().length;
                }
            } else {
                this.priorityQueue.remove(queueObject);
            }
        }
    }
}

