/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MessageQueueDatabase
extends MessageQueue {
    private static final Logger logger = Logger.getLogger(MessageQueueDatabase.class.getName());
    private Connection connection;
    private final Timer timer = new Timer(false);
    private long lastChange = System.currentTimeMillis();
    private static int counter = 0;
    private int lock = 0;
    private final Object connectionLock = new Object();
    private PreparedStatement deleteStatement;
    private PreparedStatement insertStatement;
    private PreparedStatement selectStatement;

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void close() {
        super.close();
        this.closeConnection();
    }

    @Override
    protected MessageQueue.PersistenceTask getInsertJob(QueueObject queueObject) {
        return new InsertJob(queueObject);
    }

    @Override
    protected MessageQueue.PersistenceTask getLoadJob(QueueObject result) {
        return new LoadJob(result);
    }

    @Override
    protected MessageQueue.PersistenceTask getDeleteJob(Long messageId) {
        return new DeleteJob(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeQueue() throws Exception {
        Long id;
        block22: {
            this.lockConnection();
            id = null;
            try {
                ResultSet rs;
                PreparedStatement ps = this.connection.prepareStatement("select max(id) from MESSAGES_QUEUE");
                try {
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            id = rs.getLong(1) + 1L;
                            if (!rs.wasNull()) continue;
                            id = null;
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
                if (id == null) {
                    id = 0L;
                    break block22;
                }
                logger.log(Level.FINE, "Loading persisted messages");
                ps = this.connection.prepareStatement("select ID, EXPIRES, PRIORITY, RECEIVER from MESSAGES_QUEUE where expires > ?");
                try {
                    ps.setLong(1, System.currentTimeMillis());
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            Long messageId = rs.getLong(1);
                            this.appendMessage(messageId, null, rs.getInt(3), rs.getInt(4), rs.getLong(2), true);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
                logger.log(Level.FINE, "Removing expired messages");
                ps = this.connection.prepareStatement("delete from MESSAGES_QUEUE where expires < ?");
                try {
                    ps.setLong(1, System.currentTimeMillis());
                    ps.execute();
                }
                finally {
                    ps.close();
                }
                this.connection.commit();
            }
            finally {
                this.unlockConnection();
            }
        }
        QueueObject.idGenerator = id;
        super.initializeQueue();
    }

    protected abstract void checkConnection() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockConnection() throws Exception {
        Object object = this.connectionLock;
        synchronized (object) {
            while (this.lock > 0) {
                this.connectionLock.wait();
            }
            ++this.lock;
        }
        try {
            this.checkConnection();
        }
        catch (Exception ex) {
            --this.lock;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            --this.lock;
            this.connectionLock.notify();
        }
    }

    protected void closeConnection() {
        try {
            if (this.deleteStatement != null) {
                this.deleteStatement.close();
                this.deleteStatement = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.insertStatement != null) {
                this.insertStatement.close();
                this.insertStatement = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.selectStatement != null) {
                this.selectStatement.close();
                this.selectStatement = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    class CommitTask
    extends TimerTask {
        private int counterDivider;

        CommitTask(int counterDivider) {
            MessageQueueDatabase.this.lastChange = System.currentTimeMillis();
            this.counterDivider = counterDivider;
        }

        @Override
        public void run() {
            counter++;
            if (System.currentTimeMillis() - MessageQueueDatabase.this.lastChange > 1000L || counter % this.counterDivider == 0) {
                try {
                    MessageQueueDatabase.this.lockConnection();
                    try {
                        MessageQueueDatabase.this.connection.commit();
                    }
                    finally {
                        MessageQueueDatabase.this.unlockConnection();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class InsertJob
    extends DatabaseJob {
        private QueueObject queueObject;

        InsertJob(QueueObject queueObject) {
            this.queueObject = queueObject;
        }

        @Override
        public void runTask() throws SQLException {
            if (MessageQueueDatabase.this.insertStatement == null) {
                MessageQueueDatabase.this.insertStatement = MessageQueueDatabase.this.connection.prepareStatement("insert into MESSAGES_QUEUE(ID, MESSAGE_BLOB, EXPIRES, PRIORITY, RECEIVER) values(?, ?, ?, ?, ?)");
            }
            MessageQueueDatabase.this.insertStatement.setLong(1, this.queueObject.getId());
            MessageQueueDatabase.this.insertStatement.setBytes(2, this.queueObject.getSerializedObject());
            MessageQueueDatabase.this.insertStatement.setLong(3, this.queueObject.expires);
            MessageQueueDatabase.this.insertStatement.setInt(4, this.queueObject.getPriority());
            MessageQueueDatabase.this.insertStatement.setInt(5, this.queueObject.getReceiverId());
            MessageQueueDatabase.this.insertStatement.execute();
        }
    }

    class LoadJob
    extends DatabaseJob {
        private QueueObject queueObject;

        LoadJob(QueueObject queueObject) {
            this.queueObject = queueObject;
        }

        @Override
        public void runTask() throws SQLException {
            if (MessageQueueDatabase.this.selectStatement == null) {
                MessageQueueDatabase.this.selectStatement = MessageQueueDatabase.this.connection.prepareStatement("select MESSAGE_BLOB from MESSAGES_QUEUE where ID = ?");
            }
            MessageQueueDatabase.this.selectStatement.setLong(1, this.queueObject.getId());
            ResultSet rs = MessageQueueDatabase.this.selectStatement.executeQuery();
            try {
                while (rs.next()) {
                    this.queueObject.serializedObject = rs.getBytes(1);
                }
            }
            finally {
                rs.close();
            }
        }
    }

    class DeleteJob
    extends DatabaseJob {
        private Long messageId;

        DeleteJob(Long messageId) {
            this.messageId = messageId;
        }

        @Override
        public void runTask() throws SQLException {
            if (MessageQueueDatabase.this.deleteStatement == null) {
                MessageQueueDatabase.this.deleteStatement = MessageQueueDatabase.this.connection.prepareStatement("delete from MESSAGES_QUEUE where id = ?");
            }
            MessageQueueDatabase.this.deleteStatement.setLong(1, this.messageId);
            MessageQueueDatabase.this.deleteStatement.execute();
            MessageQueueDatabase.this.timer.schedule((TimerTask)new CommitTask(100), 1050L);
        }
    }

    abstract class DatabaseJob
    implements MessageQueue.PersistenceTask {
        DatabaseJob() {
        }

        protected abstract void runTask() throws SQLException;

        @Override
        public void run() throws Exception {
            for (int exceptions = 0; exceptions < 5; ++exceptions) {
                MessageQueueDatabase.this.lockConnection();
                try {
                    this.runTask();
                }
                catch (SQLException ex) {
                    MessageQueueDatabase.this.closeConnection();
                    Thread.sleep(100L);
                    MessageQueueDatabase.this.checkConnection();
                    MessageQueueDatabase.this.unlockConnection();
                    continue;
                }
                try {
                    MessageQueueDatabase.this.timer.schedule((TimerTask)new CommitTask(10000), 1050L);
                    break;
                }
                finally {
                    MessageQueueDatabase.this.unlockConnection();
                }
            }
        }
    }
}

