/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueueDatabase;
import java.sql.Connection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class MessageQueueDatasource
extends MessageQueueDatabase {
    private String datasource;
    private long lastCheck;
    private final Timer timer = new Timer(false);

    public MessageQueueDatasource(String datasource) throws Exception {
        this.datasource = datasource;
        this.initializeQueue();
        new ConnectionCloseTask();
    }

    @Override
    protected void checkConnection() throws Exception {
        if (this.getConnection() == null) {
            InitialContext context = new InitialContext();
            DataSource ds = (DataSource)context.lookup(this.datasource);
            Connection con = ds.getConnection();
            con.setAutoCommit(false);
            this.setConnection(con);
        }
        this.lastCheck = System.currentTimeMillis();
    }

    class ConnectionCloseTask
    extends TimerTask {
        private final int THIRTY_MINUTES = 420000;
        private final int FIVE_MINUTES = 60000;

        ConnectionCloseTask() {
            MessageQueueDatasource.this.timer.schedule((TimerTask)this, new Date(), 60000L);
        }

        @Override
        public void run() {
            if (MessageQueueDatasource.this.getConnection() != null && System.currentTimeMillis() - MessageQueueDatasource.this.lastCheck > 420000L) {
                try {
                    try {
                        MessageQueueDatasource.this.lockConnection();
                        MessageQueueDatasource.this.closeConnection();
                    }
                    finally {
                        MessageQueueDatasource.this.unlockConnection();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

