/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;

public class MessageQueueFile
extends MessageQueue {
    private static final String FILE_SEPARATOR = "file.separator";
    private static final Logger logger = Logger.getLogger(MessageQueueFile.class.getName());
    private String dbDirectory;
    private static String separator = System.getProperty("file.separator");
    private List<Long> usedFiles = new ArrayList<Long>();
    private Map<Long, String> fileNameMap = new HashMap<Long, String>();

    /*
     * Unable to fully structure code
     */
    public static void main(String[] arg) {
        try {
            new MessageQueueFile().setDbDirectory("c:\\temp");
            while (true) {
                for (i = 0; i < 2000; ++i) {
                    MessageQueue.getMessageQueue().postMessage("message " + i, 0, 1000L, 1, true);
                }
                while (true) {
                    if ((qo = MessageQueue.getMessageQueue().popMessage(1, false)) == null) ** continue;
                    MessageQueue.getMessageQueue().confirmMessage(qo.getId());
                    System.out.println(qo.getId());
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    protected MessageQueueFile() {
    }

    @Override
    protected MessageQueue.PersistenceTask getInsertJob(QueueObject queueObject) {
        return new InsertJob(queueObject);
    }

    private File requestFile(Long queueId) {
        if (this.fileNameMap.containsKey(queueId)) {
            return new File(this.fileNameMap.get(queueId));
        }
        int freeIndex = this.usedFiles.indexOf(null);
        if (freeIndex < 0) {
            this.usedFiles.add(queueId);
            freeIndex = this.usedFiles.size() - 1;
        } else {
            this.usedFiles.set(freeIndex, queueId);
        }
        int parentIndex = freeIndex / 32;
        freeIndex &= 0x1F;
        File directory = new File(String.format("%3$s%1$02d", parentIndex, separator, this.dbDirectory));
        if (!directory.exists()) {
            directory.mkdir();
        }
        String fileName = String.format("%4$s%1$02d%2$s%3$02d.queue", parentIndex, separator, freeIndex, this.dbDirectory);
        this.fileNameMap.put(queueId, fileName);
        return new File(fileName);
    }

    private String releaseFile(Long queueId) {
        int freeIndex = this.usedFiles.indexOf(queueId);
        if (freeIndex >= 0) {
            this.usedFiles.set(freeIndex, null);
        }
        return this.fileNameMap.remove(queueId);
    }

    @Override
    protected MessageQueue.PersistenceTask getLoadJob(QueueObject result) {
        return new LoadJob(result);
    }

    @Override
    protected MessageQueue.PersistenceTask getDeleteJob(Long messageId) {
        return new DeleteJob(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeQueue() {
        long maxId = -1L;
        File dbDirectoryFile = new File(this.dbDirectory);
        File[] parentDirectories = dbDirectoryFile.listFiles();
        assert (parentDirectories != null);
        for (File parentDir : parentDirectories) {
            if (!parentDir.isDirectory() || !Character.isDigit(parentDir.getName().charAt(0))) continue;
            File[] queueFiles = parentDir.listFiles();
            if (queueFiles == null || queueFiles.length == 0) {
                parentDir.delete();
                continue;
            }
            for (File queueFile : queueFiles) {
                if (!queueFile.getName().endsWith(".queue")) continue;
                try {
                    QueueObject qobject;
                    FileInputStream fis = new FileInputStream(queueFile);
                    try {
                        JBossObjectInputStream ois = new JBossObjectInputStream(fis);
                        try {
                            try {
                                qobject = (QueueObject)ois.readObject();
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            ois.close();
                        }
                    }
                    finally {
                        fis.close();
                    }
                    if (qobject.expires < System.currentTimeMillis()) {
                        queueFile.delete();
                        continue;
                    }
                    this.appendMessage(qobject.getId(), qobject.getSerializedObject(), qobject.getPriority(), qobject.getReceiverId(), qobject.expires, true);
                    if (maxId >= qobject.getId()) continue;
                    maxId = qobject.getId();
                }
                catch (IOException ex) {
                    queueFile.delete();
                }
            }
        }
        maxId = maxId < 0L ? 0L : ++maxId;
        QueueObject.idGenerator = maxId;
        try {
            super.initializeQueue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setDbDirectory(String dbDirectory) {
        if (!dbDirectory.endsWith(separator)) {
            dbDirectory = dbDirectory + separator;
        }
        this.dbDirectory = dbDirectory;
        this.initializeQueue();
    }

    class InsertJob
    extends FilePersistenceJob {
        private QueueObject queueObject;

        InsertJob(QueueObject queueObject) {
            this.queueObject = queueObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runTask() throws IOException {
            FileOutputStream fos = new FileOutputStream(MessageQueueFile.this.requestFile(this.queueObject.getId()));
            try {
                JBossObjectOutputStream oos = new JBossObjectOutputStream(fos);
                try {
                    oos.writeObject(this.queueObject);
                }
                finally {
                    oos.close();
                }
            }
            finally {
                fos.close();
            }
        }
    }

    class LoadJob
    extends FilePersistenceJob {
        private QueueObject queueObject;

        LoadJob(QueueObject queueObject) {
            this.queueObject = queueObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runTask() throws IOException {
            FileInputStream fis = new FileInputStream(MessageQueueFile.this.requestFile(this.queueObject.getId()));
            try {
                JBossObjectInputStream ois = new JBossObjectInputStream(fis);
                try {
                    try {
                        QueueObject qo = (QueueObject)ois.readObject();
                        this.queueObject.serializedObject = qo.getSerializedObject();
                    }
                    catch (ClassNotFoundException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                finally {
                    ois.close();
                }
            }
            finally {
                fis.close();
            }
        }
    }

    class DeleteJob
    extends FilePersistenceJob {
        private Long messageId;

        DeleteJob(Long messageId) {
            this.messageId = messageId;
        }

        @Override
        public void runTask() throws IOException {
            String fileName = MessageQueueFile.this.releaseFile(this.messageId);
            if (fileName != null) {
                File queueFile = new File(fileName);
                queueFile.delete();
            }
        }
    }

    abstract class FilePersistenceJob
    implements MessageQueue.PersistenceTask {
        FilePersistenceJob() {
        }

        protected abstract void runTask() throws IOException;

        @Override
        public void run() throws InterruptedException {
            for (int exceptions = 0; exceptions < 5; ++exceptions) {
                try {
                    this.runTask();
                    break;
                }
                catch (IOException ex) {
                    Thread.sleep(100L);
                    continue;
                }
            }
        }
    }
}

