/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.internet.mserver.queue;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class QueueObject
implements Comparable<QueueObject>,
Externalizable {
    public static long idGenerator = 0L;
    byte[] serializedObject;
    private Long id;
    private int priority = 0;
    long expires;
    private int receiverId;
    private boolean persisted;

    public void setSerializedObject(byte[] serializedObject) {
        this.serializedObject = serializedObject;
    }

    public QueueObject() {
    }

    QueueObject(byte[] serializedObject, int priority, long expires, Integer receiverId, boolean persisted) {
        this(idGenerator++, serializedObject, priority, expires, receiverId, persisted);
    }

    public byte[] getSerializedObject() {
        return this.serializedObject;
    }

    public Long getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public Integer getReceiverId() {
        return this.receiverId >= 0 ? Integer.valueOf(this.receiverId) : null;
    }

    QueueObject(long id, byte[] serializedObject, int priority, long expires, Integer receiverId, boolean persisted) {
        this.id = id;
        this.serializedObject = serializedObject;
        this.priority = priority;
        this.expires = expires;
        this.receiverId = receiverId != null ? receiverId : -1;
        this.persisted = persisted;
    }

    public boolean isValid() {
        return this.expires >= System.currentTimeMillis();
    }

    @Override
    public int compareTo(QueueObject o) {
        int result;
        int n = o.priority < this.priority ? -1 : (result = o.priority == this.priority ? 0 : 1);
        if (result == 0) {
            result = this.id.compareTo(o.id);
        }
        return result;
    }

    public boolean equals(Object obj) {
        QueueObject that = (QueueObject)obj;
        return that.id.equals(this.id);
    }

    public int hashCode() {
        return 37 + this.id.hashCode() * 17 + this.priority * 17;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeInt(this.serializedObject.length);
        out.write(this.serializedObject);
        out.writeInt(this.priority);
        out.writeInt(this.receiverId);
        out.writeLong(this.expires);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.id = in.readLong();
        int len = in.readInt();
        this.serializedObject = new byte[len];
        in.read(this.serializedObject);
        this.priority = in.readInt();
        this.receiverId = in.readInt();
        this.expires = in.readLong();
    }

    public boolean isPersisted() {
        return this.persisted;
    }
}

