/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitoring.mserver.response;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.response.DeviceResponsePacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OIDResponsePacket
extends DeviceResponsePacket
implements Comparable<OIDResponsePacket> {
    private int oidRequestType;
    private Map<String, OIDParameterVariable> oidParameters = new HashMap<String, OIDParameterVariable>();
    private Integer monitorIteration;

    public OIDResponsePacket() {
    }

    public OIDResponsePacket(OIDResponsePacket originalPacket) {
        super(originalPacket);
        this.oidRequestType = originalPacket.oidRequestType;
        this.monitorIteration = originalPacket.monitorIteration;
        this.oidParameters.putAll(originalPacket.oidParameters);
    }

    public OIDResponsePacket(String packetMarker) {
        super(packetMarker);
    }

    @Override
    public int compareTo(OIDResponsePacket o) {
        if (this.getDeviceId() != null && o.getDeviceId() != null) {
            int result = this.getDeviceId().compareTo(o.getDeviceId());
            if (result == 0) {
                result = new Long(this.getTimeStamp()).compareTo(o.getTimeStamp());
            }
            return result;
        }
        return 0;
    }

    public List<OIDParameterVariable> getOidParameterList() {
        ArrayList<OIDParameterVariable> list = new ArrayList<OIDParameterVariable>(this.oidParameters.values());
        Collections.sort(list);
        return list;
    }

    public int getOidRequestType() {
        return this.oidRequestType;
    }

    public Map<String, OIDParameterVariable> getOidParameters() {
        return this.oidParameters;
    }

    public Integer getMonitorIteration() {
        return this.monitorIteration;
    }

    public void setOidRequestType(int oidRequestType) {
        this.oidRequestType = oidRequestType;
    }

    public void setOidParameters(Map<String, OIDParameterVariable> oidParameters) {
        this.oidParameters = oidParameters;
    }

    public void setMonitorIteration(Integer monitorIteration) {
        this.monitorIteration = monitorIteration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OIDResponsePacket)) {
            return false;
        }
        OIDResponsePacket other = (OIDResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOidRequestType() != other.getOidRequestType()) {
            return false;
        }
        Map<String, OIDParameterVariable> this$oidParameters = this.getOidParameters();
        Map<String, OIDParameterVariable> other$oidParameters = other.getOidParameters();
        if (this$oidParameters == null ? other$oidParameters != null : !((Object)this$oidParameters).equals(other$oidParameters)) {
            return false;
        }
        Integer this$monitorIteration = this.getMonitorIteration();
        Integer other$monitorIteration = other.getMonitorIteration();
        return !(this$monitorIteration == null ? other$monitorIteration != null : !((Object)this$monitorIteration).equals(other$monitorIteration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OIDResponsePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getOidRequestType();
        Map<String, OIDParameterVariable> $oidParameters = this.getOidParameters();
        result = result * 59 + ($oidParameters == null ? 43 : ((Object)$oidParameters).hashCode());
        Integer $monitorIteration = this.getMonitorIteration();
        result = result * 59 + ($monitorIteration == null ? 43 : ((Object)$monitorIteration).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OIDResponsePacket(oidRequestType=" + this.getOidRequestType() + ", monitorIteration=" + this.getMonitorIteration() + ")";
    }
}

