/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.monitoring.mserver.request.RequestStatusPacket;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class DeviceMonitoring {
    private static final Logger logger = Logger.getLogger(DeviceMonitoring.class.getName());
    private static DeviceMonitoring instance;
    @Inject
    private SnmpPoolManager snmpPoolManager;

    public DeviceMonitoring() {
        instance = this;
    }

    public static DeviceMonitoring getInstance() {
        return instance;
    }

    public void changeDeviceMonitorThreadState(Integer deviceId, boolean started) {
        if (started) {
            this.snmpPoolManager.addDeviceMonitorTask(deviceId);
        } else {
            this.snmpPoolManager.removeDeviceMonitorTask(deviceId);
        }
    }

    public void changeSnmpThreadState(Serializable packet) {
        RequestStatusPacket statusPacket = (RequestStatusPacket)packet;
        if (statusPacket.getRequestPacketType() == 1) {
            this.snmpPoolManager.updateThreadExpiring(statusPacket);
            return;
        }
        this.snmpPoolManager.addSNMPMonitorTask(statusPacket);
    }

    @PreDestroy
    public void stop() throws Exception {
        logger.info("Monitoring service stopping...");
    }
}

