/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.agent.persistence.AutoincrementPK;
import com.dsoft.powerpro.agent.persistence.FinderException;
import com.dsoft.powerpro.agent.persistence.Persistence;
import com.dsoft.powerpro.agent.persistence.PersistenceException;
import com.dsoft.powerpro.monitoring.mserver.request.RequestStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerProcessPingPacket;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersPK;
import com.dsoft.powerpro.monitorserver.dto.DevicePingResponseDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class MonitoringManager {
    private static final Logger logger = Logger.getLogger(MonitoringManager.class.getName());
    private static MonitoringManager instance;
    private boolean initialized = false;
    private Persistence persistence;

    public MonitoringManager() {
        instance = this;
    }

    public static MonitoringManager getInstance() {
        return instance;
    }

    public Persistence getPersistence() {
        while (!this.initialized) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return this.persistence;
    }

    @Inject
    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
        this.initialized = false;
    }

    public void addDevice(DeviceDTO dto) throws Exception {
        try {
            this.getPersistence().find(DeviceDTO.class, dto.getId());
            this.getPersistence().merge(dto);
        }
        catch (FinderException fe) {
            this.getPersistence().persist(dto);
        }
    }

    public void addDevicePingResponse(Integer id, Integer deviceId, long startTime, long endTime) throws Exception {
        DevicePingResponseDTO devPingResponse;
        if (id == null) {
            id = (Integer)this.getPersistence().nextPrimaryKey(DevicePingResponseDTO.class);
            devPingResponse = new DevicePingResponseDTO();
            devPingResponse.setId(id);
        } else {
            devPingResponse = this.getPersistence().find(DevicePingResponseDTO.class, id);
        }
        devPingResponse.setStartTime(startTime);
        devPingResponse.setEndTime(endTime);
        devPingResponse.setDeviceId(deviceId);
        try {
            this.getPersistence().merge(devPingResponse);
        }
        catch (FinderException ex) {
            this.getPersistence().persist(devPingResponse);
        }
    }

    public SnmpConfigsDTO addSnmpConfig(SnmpConfigsDTO confDto) throws Exception {
        try {
            this.getPersistence().find(SnmpConfigsDTO.class, confDto.getId());
            confDto = this.getPersistence().merge(confDto);
        }
        catch (FinderException fe) {
            confDto = this.getPersistence().persist(confDto);
        }
        return confDto;
    }

    private boolean checkDeviceRowValidity(long currentTime, DeviceDTO device) {
        long validFrom = -1L;
        long validTo = Long.MAX_VALUE;
        if (device.getRowIdentifier() != null) {
            if (device.getValidFrom() != null) {
                validFrom = device.getValidFrom();
            }
            if (device.getValidTo() != null) {
                validTo = device.getValidTo();
            }
            if (currentTime < validFrom || currentTime > validTo) {
                return false;
            }
        }
        return true;
    }

    private Collection<DeviceDTO> findDevicesByIP(long ipAddress) throws FinderException {
        return this.getPersistence().findEntities(DeviceDTO.class, entity -> entity.getIpAddress() != null && entity.getIpAddress() == ipAddress);
    }

    private Collection<DeviceDTO> findDevicesByMac(String macAddress) throws FinderException {
        return this.getPersistence().findEntities(DeviceDTO.class, entity -> entity.getMac() != null && entity.getMac().equalsIgnoreCase(macAddress));
    }

    public DeviceDTO getDevice(Integer deviceId) throws FinderException {
        return this.getPersistence().find(DeviceDTO.class, deviceId);
    }

    public Integer getDeviceId(long ipAddress) throws Exception {
        Collection<DeviceDTO> devices = this.findDevicesByIP(ipAddress);
        for (DeviceDTO device : devices) {
            if (!this.checkDeviceRowValidity(System.currentTimeMillis(), device)) continue;
            return device.getId();
        }
        return null;
    }

    public Integer getDeviceId(String mac) throws Exception {
        Collection<DeviceDTO> devices = this.findDevicesByMac(mac);
        for (DeviceDTO device : devices) {
            if (!this.checkDeviceRowValidity(System.currentTimeMillis(), device)) continue;
            return device.getId();
        }
        return null;
    }

    public Long getDeviceIp(Integer id) throws Exception {
        try {
            Long ip = this.getPersistence().find(DeviceDTO.class, id).getIpAddress();
            if (ip != null && ip != 0L) {
                return ip;
            }
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return null;
    }

    public DevicePingResponseDTO getDeviceLastPing(Integer deviceId) throws Exception {
        List<DevicePingResponseDTO> devicePingStates = this.getDevicePingResponses(deviceId);
        if (devicePingStates.isEmpty()) {
            return null;
        }
        devicePingStates.sort((o1, o2) -> new Long(o1.getEndTime()).compareTo(o2.getEndTime()));
        return devicePingStates.get(devicePingStates.size() - 1);
    }

    public List<DevicePingResponseDTO> getDevicePingResponses(Integer deviceId) throws Exception {
        return new ArrayList<DevicePingResponseDTO>(this.getPersistence().findEntities(DevicePingResponseDTO.class, entity -> entity.getDeviceId().equals(deviceId)));
    }

    public String getDeviceQueueName(Integer deviceId) throws FinderException {
        return this.getDevice(deviceId).getDeviceType();
    }

    public ArrayList<DeviceDTO> getDevices() throws Exception {
        return new ArrayList<DeviceDTO>(this.getPersistence().findAll(DeviceDTO.class));
    }

    public DeviceDTO getDeviceByMacAddress(String macAddress) throws FinderException {
        Collection<DeviceDTO> devices = this.findDevicesByMac(macAddress);
        long currentTime = System.currentTimeMillis();
        DeviceDTO dev = null;
        DeviceDTO newstDevice = null;
        for (DeviceDTO devDto : devices) {
            if (this.checkDeviceRowValidity(currentTime, devDto)) {
                dev = devDto;
                continue;
            }
            if (newstDevice != null && (newstDevice.getValidTo() != null ? newstDevice.getValidTo() : Long.MAX_VALUE) >= (devDto.getValidTo() != null ? devDto.getValidTo() : Long.MAX_VALUE)) continue;
            newstDevice = devDto;
        }
        if (dev == null && newstDevice != null) {
            dev = newstDevice;
        }
        return dev;
    }

    public List<DeviceDTO> getDevicesByType(String deviceTypeName) throws Exception {
        return new ArrayList<DeviceDTO>(this.getPersistence().findEntities(DeviceDTO.class, entity -> entity.isMonitorDevSpecParams() && entity.getDeviceType().equals(deviceTypeName)));
    }

    public List<DeviceDTO> getDevicesForMonitoring() throws Exception {
        return new ArrayList<DeviceDTO>(this.getPersistence().findEntities(DeviceDTO.class, DeviceDTO::isProcessMonitoring));
    }

    public SnmpConfigsDTO getDeviceSNMPConfig(Integer deviceId) throws Exception {
        if (deviceId == null) {
            return null;
        }
        SnmpConfigsDTO snmpConfig = null;
        try {
            DeviceDTO devDto = this.getPersistence().find(DeviceDTO.class, deviceId);
            if (devDto.getConfigId() != null) {
                snmpConfig = this.getPersistence().find(SnmpConfigsDTO.class, devDto.getConfigId());
            }
            return snmpConfig;
        }
        catch (FinderException ex) {
            System.out.println(deviceId);
            throw ex;
        }
    }

    public List<DeviceOidParametersDTO> getMonitoredDeviceOIDs(Integer deviceId) throws Exception {
        return new ArrayList<DeviceOidParametersDTO>(this.getPersistence().findEntities(DeviceOidParametersDTO.class, entity -> entity.getDeviceid().equals(deviceId) && entity.isProcessMonitoring()));
    }

    public List<DeviceOidParametersDTO> getOIDsForMonitoring() throws Exception {
        return new ArrayList<DeviceOidParametersDTO>(this.getPersistence().findEntities(DeviceOidParametersDTO.class, DeviceOidParametersDTO::isProcessMonitoring));
    }

    public void incrementMonitorIteration(Integer deviceId, Integer iteration) throws PersistenceException {
        DeviceDTO deviceDto;
        try {
            deviceDto = this.getPersistence().find(DeviceDTO.class, deviceId);
        }
        catch (FinderException ex) {
            return;
        }
        deviceDto.setMonitorIteration(iteration);
        this.getPersistence().merge(deviceDto);
    }

    public void removeDevice(Integer deviceId) throws PersistenceException {
        Collection<DeviceOidParametersDTO> oidParams = this.getPersistence().findEntities(DeviceOidParametersDTO.class, entity -> entity.getDeviceid().equals(deviceId));
        for (DeviceOidParametersDTO devOidDto : oidParams) {
            this.getPersistence().removeEntity(devOidDto);
        }
        try {
            DeviceDTO devDto = this.getPersistence().find(DeviceDTO.class, deviceId);
            this.getPersistence().removeEntity(devDto);
        }
        catch (FinderException finderException) {
            // empty catch block
        }
    }

    public void setDevicePingStatus(ServerProcessPingPacket processPacket) throws Exception {
        DeviceDTO deviceDto;
        try {
            deviceDto = this.getPersistence().find(DeviceDTO.class, processPacket.getDeviceId());
        }
        catch (FinderException fe) {
            deviceDto = new DeviceDTO();
            deviceDto.setId(processPacket.getDeviceId());
            deviceDto.setIpAddress(IPUtils.ipStringToLong2(processPacket.getIpAddress()));
        }
        deviceDto.setProcessMonitoring(processPacket.isProcessPingDevice());
        deviceDto.setPingType(processPacket.getPingType());
        deviceDto.setMonitorDevSpecParams(processPacket.isMonitorDevSpecParams());
        deviceDto.setMonitorParamsTimeout(processPacket.getMonitorParamsTimeout());
        deviceDto.setMonitoringTimeout(processPacket.getProcessPingDeviceTimeout());
        this.getPersistence().merge(deviceDto);
    }

    public DeviceOidParametersDTO setDeviceStatus(RequestStatusPacket packet) throws Exception {
        String oid = null;
        try {
            if (packet.getOidParameters() == null) {
                return null;
            }
            Iterator<String> it = packet.getOidParameters().iterator();
            if (!it.hasNext()) {
                return null;
            }
            oid = it.next();
            DeviceOidParametersDTO oidParam = this.getPersistence().find(DeviceOidParametersDTO.class, new DeviceOidParametersPK(packet.getDeviceId(), oid));
            if (!packet.isDeviceMonitoringActive()) {
                this.getPersistence().removeEntity(oidParam);
                oidParam.setDeviceid(packet.getDeviceId());
                oidParam.setProcessMonitoring(false);
                oidParam.setOid(oid);
                return oidParam;
            }
            oidParam.setTimeout(packet.getTimeout());
            oidParam.setProcessMonitoring(true);
            this.getPersistence().merge(oidParam);
            return oidParam;
        }
        catch (FinderException fex) {
            DeviceOidParametersDTO dto = new DeviceOidParametersDTO();
            dto.setDeviceid(packet.getDeviceId());
            dto.setOid(oid);
            if (!packet.isDeviceMonitoringActive()) {
                dto.setProcessMonitoring(false);
                return dto;
            }
            dto.setTimeout(packet.getTimeout());
            dto.setProcessMonitoring(true);
            this.getPersistence().persist(dto);
            return dto;
        }
    }

    @PostConstruct
    public void start() {
        logger.fine("Initializing monitoring manager");
        try {
            this.persistence.registerTable("device", DeviceDTO.class);
            this.persistence.registerTable("snmp_config", SnmpConfigsDTO.class);
            this.persistence.registerTable("deviceOidParam", DeviceOidParametersDTO.class);
            this.persistence.registerTable("devicePingState", DevicePingResponseDTO.class, new IntegerAutoInc());
            this.initialized = true;
        }
        catch (PersistenceException ex) {
            logger.log(Level.SEVERE, "Unable to initialize persistence mapping", ex);
            throw new RuntimeException(ex);
        }
    }

    class IntegerAutoInc
    implements AutoincrementPK {
        int currentInt = 0;

        IntegerAutoInc() {
        }

        @Override
        public void initializePKGenerator(Object[] existingKeys) {
            if (existingKeys != null) {
                Arrays.sort(existingKeys);
                this.currentInt = (Integer)existingKeys[existingKeys.length - 1] + 1;
            }
        }

        @Override
        public Object nextPK() {
            return this.currentInt++;
        }
    }
}

