/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.framework.client.exception.InvalidIPFormatException;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageListener;
import com.dsoft.powerpro.agent.persistence.FinderException;
import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.request.RegisterDevicePacket;
import com.dsoft.powerpro.monitoring.mserver.request.RequestInterfaceStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.request.RequestPacket;
import com.dsoft.powerpro.monitoring.mserver.request.RequestStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerPingPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerProcessPingPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerSNMPConfigPacket;
import com.dsoft.powerpro.monitoring.mserver.request.UnregisterDevicePacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.response.ResponseStatusPacket;
import com.dsoft.powerpro.monitorserver.DeviceMonitoring;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.util.QueueListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class MonitoringMessageProcessor
implements Runnable {
    private static final Logger logger = Logger.getLogger(MonitoringMessageProcessor.class.getName());
    private static MonitoringMessageProcessor instance;
    private final List<Packet> messageList = new ArrayList<Packet>();
    private final Map<String, Thread> localQueueThreads = new HashMap<String, Thread>();
    private final Map<String, List<QueueListener>> listenersMap = new HashMap<String, List<QueueListener>>();
    private final Map<String, List<InfoPacket>> infoPacketQueues = new HashMap<String, List<InfoPacket>>();
    private Thread writeThread;
    private MessageQueue messageQueue;
    private MonitoringManager monitoringManager;
    private DeviceMonitoring deviceMonitor;

    public MonitoringMessageProcessor() {
        instance = this;
    }

    public static MonitoringMessageProcessor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String queueName, QueueListener listener) {
        Map<String, List<QueueListener>> map = this.listenersMap;
        synchronized (map) {
            List<QueueListener> listeners = this.listenersMap.get(queueName);
            if (listeners == null) {
                listeners = new ArrayList<QueueListener>();
                this.listenersMap.put(queueName, listeners);
                Map<String, Thread> map2 = this.localQueueThreads;
                synchronized (map2) {
                    this.localQueueThreads.put(queueName, new LocalQueueThread(queueName));
                    this.localQueueThreads.get(queueName).start();
                }
            }
            listeners.add(listener);
        }
    }

    private void changeDeviceMonitorThreadState(Integer deviceId, boolean started) {
        this.deviceMonitor.changeDeviceMonitorThreadState(deviceId, started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.writeThread.interrupt();
        List<Packet> list = this.messageList;
        synchronized (list) {
            this.messageList.notifyAll();
        }
        this.stopLocalQueueThreads();
    }

    private void invokeChangeSnmpThreadState(RequestStatusPacket statusPacket) {
        this.deviceMonitor.changeSnmpThreadState(statusPacket);
    }

    private void preparePacket(DeviceRequestPacket packet) throws Exception {
        if (packet.getIpAddress() == null && packet.getDeviceId() != null) {
            Long ipLong = this.monitoringManager.getDeviceIp(packet.getDeviceId());
            String ip = ipLong != null && ipLong != 0L ? IPUtils.ipLongToString((long)ipLong) : null;
            packet.setIpAddress(ip);
        }
    }

    private void processDeviceMonitoringStatusPacket(RequestStatusPacket statusPacket) throws Exception {
        if (statusPacket.getQueueId() != null) {
            this.invokeChangeSnmpThreadState(statusPacket);
        } else {
            DeviceOidParametersDTO dto = this.monitoringManager.setDeviceStatus(statusPacket);
            if (dto != null) {
                statusPacket.setTimeout(dto.getTimeout());
                statusPacket.setDeviceMonitoringActive(dto.isProcessMonitoring());
                this.invokeChangeSnmpThreadState(statusPacket);
                ResponseStatusPacket response = new ResponseStatusPacket(statusPacket);
                response.setDeviceId(statusPacket.getDeviceId());
                this.sendInfoPacket(response, true);
            }
        }
    }

    private void processDeviceOIDParmeterPacket(DeviceOIDParameterPacket oidParamPacket) throws Exception {
        String queueName = oidParamPacket.getQueueName();
        if (oidParamPacket.getIpAddress() == null) {
            if (oidParamPacket.getDeviceId() != null) {
                if (queueName == null) {
                    queueName = this.monitoringManager.getDeviceQueueName(oidParamPacket.getDeviceId());
                }
                SnmpConfigsDTO dto = this.monitoringManager.getDeviceSNMPConfig(oidParamPacket.getDeviceId());
                Long ipLong = this.monitoringManager.getDeviceIp(oidParamPacket.getDeviceId());
                if (ipLong != null) {
                    String ip = IPUtils.ipLongToString((long)ipLong);
                    oidParamPacket.setReadCommunity(dto.getReadcommunity());
                    oidParamPacket.setWriteCommunity(dto.getWritecommunity());
                    oidParamPacket.setRetries(dto.getRetries() != null ? dto.getRetries() : 0);
                    oidParamPacket.setTimeout(dto.getTimeout());
                    oidParamPacket.setIpAddress(ip);
                    oidParamPacket.setPort(dto.getPort() != null ? dto.getPort() : 0);
                    oidParamPacket.setSnmpVersion(dto.getSnmpVersion());
                    oidParamPacket.setAuthPassword(dto.getAuthPassword());
                    oidParamPacket.setAuthProtocol(dto.getAuthProtocol());
                    oidParamPacket.setPrivPassword(dto.getPrivPassword());
                    oidParamPacket.setPrivProtocol(dto.getPrivProtocol());
                    oidParamPacket.setContextId(dto.getContextId());
                    oidParamPacket.setContextName(dto.getContextName());
                    this.sendQueuePacket(oidParamPacket, queueName);
                }
            }
        } else {
            if (oidParamPacket.getDeviceId() != null) {
                if (queueName == null) {
                    queueName = this.monitoringManager.getDeviceQueueName(oidParamPacket.getDeviceId());
                }
                SnmpConfigsDTO dto = this.monitoringManager.getDeviceSNMPConfig(oidParamPacket.getDeviceId());
                oidParamPacket.setReadCommunity(dto.getReadcommunity());
                oidParamPacket.setWriteCommunity(dto.getWritecommunity());
                oidParamPacket.setRetries(dto.getRetries() != null ? dto.getRetries() : 0);
                oidParamPacket.setTimeout(dto.getTimeout());
                oidParamPacket.setPort(dto.getPort() != null ? dto.getPort() : 0);
                oidParamPacket.setSnmpVersion(dto.getSnmpVersion());
                oidParamPacket.setAuthPassword(dto.getAuthPassword());
                oidParamPacket.setAuthProtocol(dto.getAuthProtocol());
                oidParamPacket.setPrivPassword(dto.getPrivPassword());
                oidParamPacket.setPrivProtocol(dto.getPrivProtocol());
                oidParamPacket.setContextId(dto.getContextId());
                oidParamPacket.setContextName(dto.getContextName());
                oidParamPacket.setSecurityUserName(dto.getSecurityUserName());
            }
            this.sendQueuePacket(oidParamPacket, queueName);
        }
    }

    private void processRegisterDevicePacket(RegisterDevicePacket devicePacket) throws Exception {
        Integer deviceId;
        String queueName = devicePacket.getQueueName();
        ServerSNMPConfigPacket config = devicePacket.getSnmpConfig();
        if (config != null && config.getId() != null) {
            this.processServerSNMPConfigPacket(config);
        }
        if (!StringUtil.isEmpty(devicePacket.getMac()) && (deviceId = this.monitoringManager.getDeviceId(devicePacket.getMac())) != null && devicePacket.getDeviceId() != null && !deviceId.equals(devicePacket.getDeviceId())) {
            this.monitoringManager.removeDevice(deviceId);
        }
        DeviceDTO devDto = new DeviceDTO();
        devDto.setId(devicePacket.getDeviceId());
        devDto.setConfigId(devicePacket.getConfigId());
        devDto.setIpAddress(IPUtils.ipStringToLong(devicePacket.getIpAddress()));
        devDto.setDeviceType(devicePacket.getDeviceTypeName());
        devDto.setServiceId(devicePacket.getServiceId());
        devDto.setMac(devicePacket.getMac());
        devDto.setRowIdentifier(devicePacket.getRowIdentifier());
        devDto.setValidFrom(devicePacket.getValidFrom());
        devDto.setValidTo(devicePacket.getValidTo());
        this.monitoringManager.addDevice(devDto);
        if (devicePacket.getQueueName() == null) {
            queueName = this.monitoringManager.getDeviceQueueName(devDto.getId());
        }
        if (queueName != null) {
            this.sendQueuePacket(devicePacket, queueName);
        }
    }

    private void processRequestInterfaceStatusPacket(RequestInterfaceStatusPacket packet) throws Exception {
        this.invokeChangeSnmpThreadState(packet);
    }

    private void processServerPingPacket(ServerPingPacket pingPacket) throws Exception {
        String queueName = null;
        if (pingPacket.getIpAddress() == null) {
            if (pingPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(pingPacket.getDeviceId());
            }
        } else {
            if (pingPacket.getDeviceId() == null) {
                try {
                    pingPacket.setDeviceId(this.monitoringManager.getDeviceId(IPUtils.ipStringToLong(pingPacket.getIpAddress())));
                }
                catch (InvalidIPFormatException invalidIPFormatException) {
                    // empty catch block
                }
            }
            if (pingPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(pingPacket.getDeviceId());
            }
        }
        if (queueName == null) {
            queueName = "SNMPNetworkDeviceDto";
        }
        this.sendQueuePacket(pingPacket, queueName);
    }

    private void processServerProcessPingPacket(ServerProcessPingPacket processPacket) throws Exception {
        this.monitoringManager.setDevicePingStatus(processPacket);
        this.changeDeviceMonitorThreadState(processPacket.getDeviceId(), processPacket.isProcessPingDevice());
        String queueName = this.monitoringManager.getDeviceQueueName(processPacket.getDeviceId());
        if (queueName != null) {
            this.sendQueuePacket(processPacket, queueName);
        }
        PingStatusPacket monPacket = new PingStatusPacket();
        monPacket.setDeviceId(processPacket.getDeviceId());
        monPacket.setProcessPingDevice(processPacket.isProcessPingDevice());
        monPacket.setPingType(processPacket.getPingType());
        monPacket.setMonitorDevSpecParams(processPacket.isMonitorDevSpecParams());
        monPacket.setMonitorParamsTimeout(processPacket.getMonitorParamsTimeout());
        monPacket.setProcessPingDeviceTimeout(processPacket.getProcessPingDeviceTimeout());
        this.sendInfoPacket(monPacket, true);
    }

    private void processServerSNMPConfigPacket(ServerSNMPConfigPacket configPacket) throws Exception {
        SnmpConfigsDTO confDto = new SnmpConfigsDTO();
        confDto.setId(configPacket.getId());
        confDto.setPort(configPacket.getPort());
        confDto.setReadcommunity(configPacket.getReadCommunity());
        confDto.setWritecommunity(configPacket.getWriteCommunity());
        confDto.setRetries(configPacket.getRetries());
        confDto.setTimeout(configPacket.getTimeout());
        confDto.setSnmpVersion(configPacket.getSnmpVersion());
        confDto.setAuthPassword(configPacket.getAuthPassword());
        confDto.setAuthProtocol(configPacket.getAuthProtocol());
        confDto.setPrivPassword(configPacket.getPrivPassword());
        confDto.setPrivProtocol(configPacket.getPrivProtocol());
        confDto.setContextId(configPacket.getContextId());
        confDto.setContextName(configPacket.getContextName());
        confDto.setSecurityUserName(configPacket.getSecurityUserName());
        this.monitoringManager.addSnmpConfig(confDto);
    }

    private void processUnregisterDevicePacket(UnregisterDevicePacket devicePacket) throws Exception {
        String queueName = null;
        List<DeviceOidParametersDTO> list = this.monitoringManager.getMonitoredDeviceOIDs(devicePacket.getDeviceId());
        for (DeviceOidParametersDTO dto : list) {
            TreeSet<String> oid = new TreeSet<String>();
            oid.add(dto.getOid());
            RequestStatusPacket statusPacket = new RequestStatusPacket();
            statusPacket.setDeviceId(dto.getDeviceid());
            statusPacket.setTimeout(dto.getTimeout());
            statusPacket.setDeviceMonitoringActive(false);
            statusPacket.setOidParameters(oid);
            this.invokeChangeSnmpThreadState(statusPacket);
        }
        try {
            queueName = this.monitoringManager.getDeviceQueueName(devicePacket.getDeviceId());
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        if (queueName != null) {
            this.sendQueuePacket(devicePacket, queueName);
        }
        this.monitoringManager.removeDevice(devicePacket.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ArrayList<Serializable> lowPrioPackets = new ArrayList<Serializable>();
            while (!Thread.currentThread().isInterrupted()) {
                if (this.messageList.isEmpty()) {
                    List<Packet> list = this.messageList;
                    synchronized (list) {
                        try {
                            this.messageList.wait(1000L);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this.messageList.isEmpty() && lowPrioPackets.isEmpty()) continue;
                if (this.messageList.isEmpty() && !lowPrioPackets.isEmpty()) {
                    this.writeDataToQueue(lowPrioPackets, false);
                    lowPrioPackets.clear();
                }
                long totalTimeToSend = 0L;
                int counter = 0;
                while (!this.messageList.isEmpty() && !Thread.currentThread().isInterrupted()) {
                    long start = System.currentTimeMillis();
                    ArrayList<Serializable> highPrioPackets = new ArrayList<Serializable>();
                    List<Packet> list = this.messageList;
                    synchronized (list) {
                        for (Packet packet : this.messageList) {
                            if (packet.highPriority) {
                                highPrioPackets.add(packet.infoPacket);
                                continue;
                            }
                            lowPrioPackets.add(packet.infoPacket);
                        }
                        this.messageList.clear();
                    }
                    if (!highPrioPackets.isEmpty()) {
                        if (highPrioPackets.size() == 1) {
                            this.sendSinglePacket((Serializable)highPrioPackets.get(0), true);
                        } else {
                            this.writeDataToQueue(highPrioPackets, true);
                        }
                        counter += highPrioPackets.size();
                    }
                    if (!lowPrioPackets.isEmpty()) {
                        if (lowPrioPackets.size() == 1) {
                            this.sendSinglePacket((Serializable)lowPrioPackets.get(0), false);
                            lowPrioPackets.clear();
                            ++counter;
                        } else if (lowPrioPackets.size() > 20) {
                            this.writeDataToQueue(lowPrioPackets, false);
                            counter += lowPrioPackets.size();
                            lowPrioPackets.clear();
                        }
                    }
                    totalTimeToSend += System.currentTimeMillis() - start;
                    if (counter <= 100) continue;
                    logger.log(Level.FINE, String.format("Average time to send message %1$dms for %2$d messages", totalTimeToSend / (long)counter, counter));
                }
                if (counter <= 0) continue;
                logger.log(Level.FINE, String.format("Average time to send message %1$dms for %2$d messages", totalTimeToSend / (long)counter, counter));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendInfoPacket(Serializable infoPacket, boolean highPriority) {
        if (infoPacket == null) {
            return;
        }
        Packet packet = new Packet();
        packet.infoPacket = infoPacket;
        packet.highPriority = highPriority;
        List<Packet> list = this.messageList;
        synchronized (list) {
            if (highPriority) {
                this.messageList.add(0, packet);
            } else {
                this.messageList.add(packet);
            }
            this.messageList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuePacket(InfoPacket infoPacket, String queueName) {
        Map<String, List<InfoPacket>> map = this.infoPacketQueues;
        synchronized (map) {
            List<InfoPacket> packetQueue = this.infoPacketQueues.get(queueName);
            if (packetQueue == null) {
                if (this.localQueueThreads.containsKey(queueName)) {
                    packetQueue = new ArrayList<InfoPacket>();
                    this.infoPacketQueues.put(queueName, packetQueue);
                } else {
                    return;
                }
            }
            packetQueue.add(infoPacket);
            this.infoPacketQueues.notifyAll();
        }
    }

    private void sendSinglePacket(Serializable packet, boolean highPriority) throws Exception {
        try {
            this.writeDataToQueue(packet, highPriority);
        }
        catch (Exception ex) {
            this.sendInfoPacket(packet, highPriority);
            throw ex;
        }
    }

    @Inject
    public void setDeviceMonitor(DeviceMonitoring deviceMonitor) {
        this.deviceMonitor = deviceMonitor;
    }

    @Inject
    public void setMessageDistributor(MessageDistributor distributor) {
        distributor.addMessageListener(RequestPacket.class, new MessageProcessThread());
    }

    @Inject
    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Inject
    public void setMonitoringManager(MonitoringManager monitoringManager) {
        this.monitoringManager = monitoringManager;
    }

    @Inject
    public void setThreadGroup(ThreadGroup threadGroup) {
        this.writeThread = new Thread(threadGroup, this);
    }

    @PostConstruct
    public void start() {
        this.writeThread.start();
    }

    @PreDestroy
    public void stop() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLocalQueueThreads() {
        Map<String, Thread> map = this.localQueueThreads;
        synchronized (map) {
            for (Thread thread : this.localQueueThreads.values()) {
                thread.interrupt();
            }
        }
    }

    private void writeDataToQueue(Object infoPacket, boolean highPriority) throws Exception {
        this.messageQueue.postMessage(infoPacket, highPriority ? new Integer(1) : new Integer(0), 86400000L, 0, true);
    }

    class Packet {
        Serializable infoPacket;
        boolean highPriority;

        Packet() {
        }
    }

    class MessageProcessThread
    implements MessageListener {
        MessageProcessThread() {
        }

        @Override
        public void beginProcessing() {
        }

        @Override
        public void endProcessing() {
        }

        @Override
        public void processMessage(Object message) {
            if (message instanceof RequestPacket) {
                RequestPacket packet = (RequestPacket)message;
                this.processPacket(packet);
            }
        }

        private void processPacket(RequestPacket packet) {
            try {
                if (packet instanceof DeviceRequestPacket) {
                    DeviceRequestPacket drp = (DeviceRequestPacket)packet;
                    MonitoringMessageProcessor.this.preparePacket(drp);
                    if (drp.getDeviceId() == null && !StringUtil.isEmpty(drp.getQueueName())) {
                        MonitoringMessageProcessor.this.sendQueuePacket(packet, drp.getQueueName());
                        return;
                    }
                }
                if (packet instanceof ServerPingPacket) {
                    MonitoringMessageProcessor.this.processServerPingPacket((ServerPingPacket)packet);
                }
                if (packet instanceof DeviceOIDParameterPacket) {
                    MonitoringMessageProcessor.this.processDeviceOIDParmeterPacket((DeviceOIDParameterPacket)packet);
                }
                if (packet instanceof RequestInterfaceStatusPacket) {
                    MonitoringMessageProcessor.this.processRequestInterfaceStatusPacket((RequestInterfaceStatusPacket)packet);
                } else if (packet instanceof RequestStatusPacket) {
                    MonitoringMessageProcessor.this.processDeviceMonitoringStatusPacket((RequestStatusPacket)packet);
                }
                if (packet instanceof ServerProcessPingPacket) {
                    MonitoringMessageProcessor.this.processServerProcessPingPacket((ServerProcessPingPacket)packet);
                }
                if (packet instanceof RegisterDevicePacket) {
                    MonitoringMessageProcessor.this.processRegisterDevicePacket((RegisterDevicePacket)packet);
                }
                if (packet instanceof UnregisterDevicePacket) {
                    MonitoringMessageProcessor.this.processUnregisterDevicePacket((UnregisterDevicePacket)packet);
                }
                if (packet instanceof ServerSNMPConfigPacket) {
                    MonitoringMessageProcessor.this.processServerSNMPConfigPacket((ServerSNMPConfigPacket)packet);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    class LocalQueueThread
    extends Thread {
        private String queueName;

        LocalQueueThread(String queueName) {
            super("Local queue thread for " + queueName);
            this.queueName = queueName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                ArrayList queueCopy = new ArrayList();
                Map map = MonitoringMessageProcessor.this.infoPacketQueues;
                synchronized (map) {
                    List packetQueue;
                    while ((packetQueue = (List)MonitoringMessageProcessor.this.infoPacketQueues.get(this.queueName)) == null || packetQueue.isEmpty()) {
                        try {
                            MonitoringMessageProcessor.this.infoPacketQueues.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    queueCopy.addAll(packetQueue);
                    packetQueue.clear();
                }
                map = MonitoringMessageProcessor.this.listenersMap;
                synchronized (map) {
                    for (InfoPacket packet : queueCopy) {
                        for (QueueListener listener : (List)MonitoringMessageProcessor.this.listenersMap.get(this.queueName)) {
                            try {
                                listener.processPacket(packet);
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                        }
                    }
                }
            }
        }
    }
}

