/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageDistributorImpl;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import com.dsoft.powerpro.agent.messaging.MonitoringAgent;
import com.dsoft.powerpro.agent.persistence.NoSQLDatabasePersistence;
import com.dsoft.powerpro.agent.persistence.PersistenceAdapter;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitorserver.DeviceMonitoring;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.ServerProperties;
import com.dsoft.powerpro.monitorserver.devices.IPDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.MTADeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.SNMPDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.icmp.PingPoolManager;
import com.dsoft.powerpro.monitorserver.messaging.GatewayMessageQueue;
import com.dsoft.powerpro.monitorserver.snmp.SNMPTrapServer;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import com.dsoft.powerpro.monitorserver.syslog.ProcessPacketThread;
import com.dsoft.powerpro.monitorserver.util.LinuxRuntime;
import com.dsoft.powerpro.syslog.server.SyslogPacketReceiver;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.picocontainer.Characteristics;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

public class SNMPMonitoringServer {
    public static void main(String[] args) {
        ConsoleHandler consoleHandler;
        FileHandler debughandler;
        try {
            debughandler = new FileHandler("monitoring.log");
            consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SimpleFormatter(){
                private String lineSeparator = System.getProperty("line.separator");

                @Override
                public synchronized String format(LogRecord record) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format("%1$td %1$tm %1$tY %1$tH:%1$tM:%1$tS", record.getMillis()));
                    if (record.getSourceMethodName() != null) {
                        sb.append(" [");
                        sb.append(record.getSourceMethodName());
                        sb.append("]");
                    }
                    sb.append(" ");
                    sb.append(this.formatMessage(record));
                    sb.append(this.lineSeparator);
                    return sb.toString();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        debughandler.setLevel(Level.WARNING);
        Logger.getLogger("com.dsoft").addHandler(debughandler);
        Logger.getLogger("com.dsoft").addHandler(consoleHandler);
        try {
            DefaultPicoContainer container = new DefaultPicoContainer(new JavaEE5LifecycleStrategy(new NullComponentMonitor()), null);
            container.as(Characteristics.CACHE).addComponent(DefaultPicoContainer.class, container, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(LinuxRuntime.class);
            container.as(Characteristics.CACHE).addComponent(String[].class, args, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(BaseServerProperties.class, ServerProperties.class, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(ThreadGroup.class, new ThreadGroup("SNMP Monitoring threads"), new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(MessageQueue.class, GatewayMessageQueue.class, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(MessagingAgent.class, MonitoringAgent.class, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(MessageDistributor.class, MessageDistributorImpl.class, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(SyslogPacketReceiver.class);
            container.as(Characteristics.CACHE).addComponent(SNMPTrapServer.class);
            container.as(Characteristics.CACHE).addComponent(MonitoringMessageProcessor.class);
            container.as(Characteristics.CACHE).addComponent(DeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(PingPoolManager.class);
            container.as(Characteristics.CACHE).addComponent(MonitoringManager.class);
            container.as(Characteristics.CACHE).addComponent(SNMPDeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(IPDeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(CMTSDeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(MTADeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(CMDeviceMonitoring.class);
            container.as(Characteristics.CACHE).addComponent(ProcessPacketThread.class);
            container.as(Characteristics.CACHE).addComponent(PersistenceAdapter.class, NoSQLDatabasePersistence.class, new Parameter[0]);
            container.as(Characteristics.CACHE).addComponent(SnmpPoolManager.class);
            container.getComponent(SNMPDeviceMonitoring.class);
            container.getComponent(IPDeviceMonitoring.class);
            container.getComponent(CMTSDeviceMonitoring.class);
            container.getComponent(MTADeviceMonitoring.class);
            container.getComponent(CMDeviceMonitoring.class);
            container.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

