/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.BaseServerProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class ServerProperties
extends BaseServerProperties {
    private static final ArrayList<String> SHORT_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            this.add("");
            this.add("");
            this.add("");
            this.add("");
        }
    };
    private static final ArrayList<String> LONG_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("--snmp-pool");
            this.add("--icmp-pool");
            this.add("--snmp-trap-port");
            this.add("--snmp-trap-bind");
            this.add("--snmp-trap-community");
        }
    };
    private HashMap<Options, String> propertiesMap = new HashMap();
    private int snmpPool;
    private int icmpPool;
    private int snmpTrapPort;
    private InetAddress snmpBindAddress;

    public ServerProperties() {
        this.propertiesMap.put(Options.SNMP_POOL, "30");
        this.propertiesMap.put(Options.ICMP_POOL, "10");
        this.propertiesMap.put(Options.SNMP_COMMUNITY, "public");
        this.propertiesMap.put(Options.SNMP_TRAP_BIND, "0.0.0.0");
        this.propertiesMap.put(Options.SNMP_TRAP_PORT, "162");
    }

    @Override
    protected void displayProductName() {
        System.out.println("PowerPro Monitoring Agent Version 2.0");
        System.out.println("Copyright (c) 2009, 2011 dSoft-Bulgaria Ltd.");
    }

    @Override
    @Inject
    public void setArgs(String[] args) {
        super.setArgs(args);
    }

    @PostConstruct
    public void start() {
        this.verifyOptionValues();
    }

    @Override
    protected void displayUsageOptions() {
        super.displayUsageOptions();
        System.out.println("  --snmp-pool=count     Provides the max number of threads for SNMP thread pool. Default is 30.");
        System.out.println("  --icmp-pool=count     Provides the max number of threads for ICMP thread pool. Default is 10.");
        System.out.println("  --snmp-trap-bind=ip   Provides the ip address where to listen for incoming trap packets. Default is to listen on all IP addresses.(0.0.0.0)");
        System.out.println("  --snmp-trap-port=port Provides port number where to listen for trap packets. Default is 162.");
        System.out.println("  --snmp-trap-community=community\n                        Community for trap packets. Default is \"public\"");
    }

    public int getIcmpPool() {
        return this.icmpPool;
    }

    public void setIcmpPool(int icmpPool) {
        this.icmpPool = icmpPool;
    }

    public int getSnmpPool() {
        return this.snmpPool;
    }

    public void setSnmpPool(int snmpPool) {
        this.snmpPool = snmpPool;
    }

    public String getSnmpCommunity() {
        return this.propertiesMap.get((Object)Options.SNMP_COMMUNITY);
    }

    public InetAddress getSnmpTrapAddress() {
        return this.snmpBindAddress;
    }

    public Integer getSnmpTrapPort() {
        return this.snmpTrapPort;
    }

    @Override
    protected boolean processParam(String arg, int param) throws Exception {
        if (param >= 10) {
            switch (Options.values()[param -= 10]) {
                case SNMP_POOL: 
                case ICMP_POOL: 
                case SNMP_COMMUNITY: 
                case SNMP_TRAP_BIND: 
                case SNMP_TRAP_PORT: {
                    this.propertiesMap.put(Options.values()[param], arg);
                    return true;
                }
            }
            return false;
        }
        return super.processParam(arg, param);
    }

    @Override
    protected int recognizeLongOption(String paramName) {
        int result = LONG_OPTIONS.indexOf(paramName);
        if (result < 0) {
            return super.recognizeLongOption(paramName);
        }
        return result + 10;
    }

    @Override
    protected int recognizeShortOption(String paramName) {
        int result = SHORT_OPTIONS.indexOf(paramName);
        if (result < 0) {
            return super.recognizeShortOption(paramName);
        }
        return result + 10;
    }

    @Override
    protected void verifyOptionValues() {
        super.verifyOptionValues();
        try {
            this.snmpPool = Integer.parseInt(this.propertiesMap.get((Object)Options.SNMP_POOL));
            if (this.snmpPool <= 0 || this.snmpPool >= 100) {
                this.showErrorAndExit(String.format("Invalid value for SNMP thread pool size (%1$s)! Valid values are between 1 and 100.", this.propertiesMap.get((Object)Options.SNMP_POOL)));
            }
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid value for SNMP thread pool size (%1$s)!", this.propertiesMap.get((Object)Options.SNMP_POOL)));
        }
        try {
            this.icmpPool = Integer.parseInt(this.propertiesMap.get((Object)Options.ICMP_POOL));
            if (this.icmpPool <= 0 || this.icmpPool >= 100) {
                this.showErrorAndExit(String.format("Invalid value for ICMP thread pool size (%1$s)! Valid values are between 1 and 100.", this.propertiesMap.get((Object)Options.ICMP_POOL)));
            }
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid value for ICMP thread pool size (%1$s)!", this.propertiesMap.get((Object)Options.ICMP_POOL)));
        }
        try {
            this.snmpTrapPort = Integer.parseInt(this.propertiesMap.get((Object)Options.SNMP_TRAP_PORT));
            if (this.snmpTrapPort <= 0 || this.snmpTrapPort >= 65535) {
                this.showErrorAndExit(String.format("Invalid value for SNMP Trap port (%1$s)! Valid values are between 1 and 65535.", this.propertiesMap.get((Object)Options.SNMP_TRAP_PORT)));
            }
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid value for SNMP Trap port (%1$s)!", this.propertiesMap.get((Object)Options.SNMP_TRAP_PORT)));
        }
        try {
            this.snmpBindAddress = InetAddress.getByName(this.propertiesMap.get((Object)Options.SNMP_TRAP_BIND));
        }
        catch (UnknownHostException e) {
            this.showErrorAndExit(String.format("Invalid value for SNMP Trap bind address (%1$s)!", this.propertiesMap.get((Object)Options.SNMP_TRAP_BIND)));
        }
    }

    public InetAddress getSnmpBindAddress() {
        return this.snmpBindAddress;
    }

    static enum Options {
        SNMP_POOL,
        ICMP_POOL,
        SNMP_TRAP_PORT,
        SNMP_TRAP_BIND,
        SNMP_COMMUNITY;

    }
}

