/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.agent.persistence.FinderException;
import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerPingPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.icmp.PingPoolManager;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import com.dsoft.powerpro.monitorserver.util.QueueListener;
import java.util.Map;
import org.picocontainer.annotations.Inject;

public class BaseDeviceMonitoring
implements QueueListener {
    @Inject
    private PingPoolManager pingPoolManager;
    @Inject
    private MonitoringManager monitoringManager;

    public MonitoringManager getMonitoringManager() {
        return this.monitoringManager;
    }

    public void invokeChangePingThreadState(ServerPingPacket pingPacket) {
        DeviceDTO dto = null;
        if (pingPacket.getPingType() == 2) {
            if (pingPacket.getDeviceId() != null) {
                try {
                    dto = this.monitoringManager.getDevice(pingPacket.getDeviceId());
                }
                catch (FinderException finderException) {
                    // empty catch block
                }
            }
            if (dto == null || dto.getConfigId() == null) {
                pingPacket.setPingType(1);
            }
        }
        if (this.pingPoolManager == null) {
            return;
        }
        if (pingPacket.getRequestPacketType() == 1) {
            this.pingPoolManager.updateThreadExpiring(pingPacket);
        } else {
            this.pingPoolManager.removeThread(pingPacket);
            if (pingPacket.isProcessPing()) {
                this.pingPoolManager.addNewThread(pingPacket);
            }
        }
    }

    @Override
    public void processPacket(InfoPacket packet) {
        if (packet instanceof DeviceOIDParameterPacket) {
            DeviceOIDParameterPacket oidParamPacket = (DeviceOIDParameterPacket)packet;
            SNMPRequestMonitor snmpMonitor = new SNMPRequestMonitor(oidParamPacket);
            snmpMonitor.monitorDeviceParameters();
        } else if (packet instanceof ServerPingPacket) {
            ServerPingPacket pingPacket = (ServerPingPacket)packet;
            this.invokeChangePingThreadState(pingPacket);
        }
    }

    public static int getInt(Map<String, OIDParameterVariable> map, String oid) {
        return map.get(oid).getVariableBinding().getVariable().toInt();
    }

    public static int getInt(Map<String, OIDParameterVariable> map, String base, int ... index) {
        StringBuilder sb = BaseDeviceMonitoring.getOid(base, index);
        return map.get(sb.toString()).getVariableBinding().getVariable().toInt();
    }

    private static StringBuilder getOid(String base, int[] index) {
        StringBuilder sb = new StringBuilder(base);
        for (int idx : index) {
            sb.append(".").append(idx);
        }
        return sb;
    }

    public static long getLong(Map<String, OIDParameterVariable> map, String oid) {
        return map.get(oid).getVariableBinding().getVariable().toLong();
    }

    public static long getLong(Map<String, OIDParameterVariable> map, String base, int ... index) {
        StringBuilder sb = BaseDeviceMonitoring.getOid(base, index);
        return map.get(sb.toString()).getVariableBinding().getVariable().toLong();
    }

    public static long getLong(Map<String, OIDParameterVariable> map, String base, String defaultBase, int ... index) {
        StringBuilder sb = BaseDeviceMonitoring.getOid(base, index);
        StringBuilder defaultSb = BaseDeviceMonitoring.getOid(defaultBase, index);
        if (map.containsKey(sb.toString()) && map.get(sb.toString()).getVariableBinding().getSyntax() != 128) {
            return map.get(sb.toString()).getVariableBinding().getVariable().toLong();
        }
        return map.get(defaultSb.toString()).getVariableBinding().getVariable().toLong();
    }

    public static String getString(Map<String, OIDParameterVariable> map, String oid) {
        return map.get(oid).getVariableBinding().getVariable().toString();
    }

    public static String getString(Map<String, OIDParameterVariable> map, String base, int ... index) {
        StringBuilder sb = BaseDeviceMonitoring.getOid(base, index);
        return map.get(sb.toString()).getVariableBinding().getVariable().toString();
    }
}

