/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerProcessPingPacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.devices.BaseDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.snmp.SNMPTrafficMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class SNMPDeviceMonitoring
extends BaseDeviceMonitoring {
    private static final Logger LOGGER = Logger.getLogger(SNMPDeviceMonitoring.class.getName());
    @Inject
    private MonitoringMessageProcessor msgProcessor;
    @Inject
    private SnmpPoolManager snmpPoolManager;

    private void changeSNMPTrafficMonitorTaskState(Integer deviceId, boolean state) {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(deviceId, null, null);
            if (packet == null) {
                return;
            }
            if (state) {
                DeviceDTO dto = this.getMonitoringManager().getDevice(deviceId);
                SNMPTrafficMonitoringThread thread = new SNMPTrafficMonitoringThread(packet, dto.getMonitorParamsTimeout() > 0L ? dto.getMonitorParamsTimeout() : 300000L, dto.getMonitorIteration());
                this.snmpPoolManager.registerThread(thread, false);
            } else {
                this.snmpPoolManager.removeThread(SNMPTrafficMonitoringThread.constructThreadId(packet));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @PostConstruct
    public void startSNMPTrafficMonitorTask() {
        this.msgProcessor.addListener("SNMPNetworkDeviceDto", this);
        this.msgProcessor.addListener("CableModemDto", this);
        try {
            List<DeviceDTO> devices = this.getMonitoringManager().getDevicesByType("SNMPNetworkDeviceDto");
            for (DeviceDTO dto : devices) {
                DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(dto.getId(), null, null);
                if (packet == null) {
                    return;
                }
                SNMPTrafficMonitoringThread thread = new SNMPTrafficMonitoringThread(packet, dto.getMonitorParamsTimeout() > 0L ? dto.getMonitorParamsTimeout() : 300000L, dto.getMonitorIteration());
                this.snmpPoolManager.registerThread(thread, true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void processPacket(InfoPacket packet) {
        if (packet instanceof ServerProcessPingPacket) {
            ServerProcessPingPacket processPacket = (ServerProcessPingPacket)packet;
            this.changeSNMPTrafficMonitorTaskState(processPacket.getDeviceId(), processPacket.isMonitorDevSpecParams());
        } else {
            super.processPacket(packet);
        }
    }
}

