/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.smi.VariableBinding;

public class SNMPMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(SNMPMonitoringThread.class.getName());

    public SNMPMonitoringThread(DeviceOIDParameterPacket packet, long timeout) {
        super(packet, timeout);
    }

    public static String constructThreadId(DeviceOIDParameterPacket packet, String explicitThrId) {
        String oid = null;
        StringBuilder id = new StringBuilder("Monitor:" + packet.getDeviceId() + ":");
        TreeSet<String> oids = new TreeSet<String>();
        if (explicitThrId == null && packet.getOidParameters() != null) {
            for (VariableBinding element : packet.getOidParameters()) {
                oid = element.getOid().toString();
                oids.add(oid);
            }
            for (String oidstr : oids) {
                id.append(oidstr).append(":");
            }
        } else {
            id.append(explicitThrId).append(":");
        }
        if (packet.getQueueId() != null) {
            id.append(packet.getQueueId());
        }
        return id.toString();
    }

    @Override
    protected String getIdString() {
        return SNMPMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket(), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(((InfoPacket)this.getPacket()).getQueueId() != null ? 420000L : -System.currentTimeMillis());
            SNMPRequestMonitor snmpMonitor = new SNMPRequestMonitor((DeviceOIDParameterPacket)this.getPacket());
            while (!this.isStopped()) {
                snmpMonitor.monitorDeviceParameters();
                if (this.isExpired()) return;
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

