/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.cablemodem.mserver.ChannelMonitoringInfo;
import com.dsoft.powerpro.cablemodem.mserver.DOCSIS;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.devices.modem.ModemStatus;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class CMMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(CMMonitor.class.getName());

    public CMMonitor() {
    }

    public CMMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModemStatus readMonitoringValues(ModemStatus modemStatus) {
        try {
            Snmp snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                if (!this.readModemSNMPData(snmpSession, modemStatus)) {
                    ModemStatus modemStatus2 = null;
                    return modemStatus2;
                }
                ArrayList<OIDParameterVariable> oidList = new ArrayList<OIDParameterVariable>();
                this.readInterfaceIOStats(snmpSession, oidList, new int[]{6, 127, 128, 129, 160});
                modemStatus.setOidParameters(oidList.stream().collect(Collectors.toMap(oid -> oid.getVariableBinding().getOid().toString(), Function.identity())));
                ModemStatus modemStatus3 = modemStatus;
                return modemStatus3;
            }
            catch (Exception ex) {
                this.closeSession(snmpSession, true);
                throw ex;
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex2) {
            logger.log(Level.SEVERE, ex2.getMessage(), ex2);
            return null;
        }
    }

    private boolean readModemSNMPData(Snmp snmpSession, ModemStatus modemStatus) throws IOException {
        logger.finer("Read modem SNMP Data");
        Map<String, OIDParameterVariable> response = this.getOidVariables(snmpSession, -95, "1.3.6.1.2.1.10.127.1");
        if (response == null || response.isEmpty()) {
            return false;
        }
        OIDParameterVariable variable = response.values().iterator().next();
        if (!variable.getVariableBinding().getOid().startsWith(new OID("1.3.6.1.2.1.10.127.1"))) {
            return false;
        }
        logger.finer("Read modem DOCSIS 2 information");
        Map<String, OIDParameterVariable> docsis2Tables = this.getOidTableVariables(snmpSession, "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.3", "1.3.6.1.2.1.10.127.1.1.1.1.6", "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.3", "1.3.6.1.2.1.10.127.1.1.4.1.3", "1.3.6.1.2.1.10.127.1.1.4.1.4", "1.3.6.1.2.1.10.127.1.1.4.1.5", "1.3.6.1.2.1.10.127.1.1.4.1.6", "1.3.6.1.2.1.10.127.1.1.4.1.9", "1.3.6.1.2.1.10.127.1.1.4.1.10", "1.3.6.1.2.1.10.127.1.2.2.1.3", "1.3.6.1.4.1.4491.2.1.20.1.1.1.1");
        if (docsis2Tables == null || docsis2Tables.isEmpty()) {
            return false;
        }
        Map<Integer, ChannelMonitoringInfo> downstreamInfo = docsis2Tables.keySet().stream().filter(o -> o.startsWith("1.3.6.1.2.1.10.127.1.1.1.1.2")).map(docsis2Tables::get).map(oid -> this.convertToChannelInfo((OIDParameterVariable)oid, modemStatus.modemDownstreamInfoMap)).collect(Collectors.toMap(ChannelMonitoringInfo::getIndex, Function.identity()));
        Map<Integer, ChannelMonitoringInfo> upstreamInfo = docsis2Tables.keySet().stream().filter(o -> o.startsWith("1.3.6.1.2.1.10.127.1.1.2.1.2")).map(docsis2Tables::get).map(oid -> this.convertToChannelInfo((OIDParameterVariable)oid, modemStatus.modemUpstreamInfoMap)).collect(Collectors.toMap(ChannelMonitoringInfo::getIndex, Function.identity()));
        this.updateStatusPropertyInt(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.1.1.6", downstreamInfo, ChannelMonitoringInfo::setPowerLevel);
        this.updateStatusPropertyInt(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.5", downstreamInfo, ChannelMonitoringInfo::setSnr);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.2", downstreamInfo, ChannelMonitoringInfo::setCorrect);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.3", downstreamInfo, ChannelMonitoringInfo::setCorrected);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.4", downstreamInfo, ChannelMonitoringInfo::setUncorrected);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.9", downstreamInfo, ChannelMonitoringInfo::setCorrected);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.10", downstreamInfo, ChannelMonitoringInfo::setUncorrected);
        this.updateStatusPropertyLong(docsis2Tables, "1.3.6.1.2.1.10.127.1.1.4.1.6", downstreamInfo, ChannelMonitoringInfo::setMicroReflections);
        List docsis3Mib = docsis2Tables.keySet().stream().filter(oid -> oid.startsWith("1.3.6.1.4.1.4491.2.1.20.1.1.1.1")).collect(Collectors.toList());
        if (docsis3Mib.isEmpty()) {
            Optional<OIDParameterVariable> oidParameterVariable = docsis2Tables.keySet().stream().filter(o -> o.startsWith("1.3.6.1.2.1.10.127.1.2.2.1.3")).map(docsis2Tables::get).findFirst();
            if (!upstreamInfo.isEmpty()) {
                try {
                    oidParameterVariable.ifPresent(var -> ((ChannelMonitoringInfo)upstreamInfo.get(upstreamInfo.keySet().iterator().next())).setTransmitLevel(var.getVariableBinding().getVariable().toInt()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        modemStatus.setDocsis(DOCSIS.DOCSIS3_0);
        response = this.getOidTableVariables(snmpSession, "1.3.6.1.4.1.4491.2.1.20.1.2.1.1");
        this.updateStatusPropertyInt(response, "1.3.6.1.4.1.4491.2.1.20.1.2.1.1", upstreamInfo, ChannelMonitoringInfo::setTransmitLevel);
        return true;
    }

    private void updateStatusPropertyInt(Map<String, OIDParameterVariable> docsis2Tables, String oidStr, Map<Integer, ChannelMonitoringInfo> channelInfoMap, BiConsumer<ChannelMonitoringInfo, Integer> setFunction) {
        docsis2Tables.keySet().stream().filter(o -> o.startsWith(oidStr)).map(docsis2Tables::get).forEach(oid -> {
            VariableBinding variableBinding = oid.getVariableBinding();
            int interfaceIndex = variableBinding.getOid().last();
            if (channelInfoMap.containsKey(interfaceIndex)) {
                setFunction.accept((ChannelMonitoringInfo)channelInfoMap.get(interfaceIndex), variableBinding.getVariable().toInt());
            }
        });
    }

    private void updateStatusPropertyLong(Map<String, OIDParameterVariable> docsis2Tables, String oidStr, Map<Integer, ChannelMonitoringInfo> channelInfoMap, BiConsumer<ChannelMonitoringInfo, Long> setFunction) {
        docsis2Tables.keySet().stream().filter(o -> o.startsWith(oidStr)).map(docsis2Tables::get).forEach(oid -> {
            VariableBinding variableBinding = oid.getVariableBinding();
            int interfaceIndex = variableBinding.getOid().last();
            if (channelInfoMap.containsKey(interfaceIndex)) {
                setFunction.accept((ChannelMonitoringInfo)channelInfoMap.get(interfaceIndex), variableBinding.getVariable().toLong());
            }
        });
    }

    private ChannelMonitoringInfo convertToChannelInfo(OIDParameterVariable oid, Map<Integer, ChannelMonitoringInfo> channelMonitoringInfoMap) {
        int interfaceIndex = oid.getVariableBinding().getOid().last();
        long frequency = oid.getVariableBinding().getVariable().toLong();
        ChannelMonitoringInfo info = channelMonitoringInfoMap.values().stream().filter(ci -> ci.getFrequency() == frequency).findFirst().orElseGet(() -> new ChannelMonitoringInfo(interfaceIndex, frequency));
        info.setIndex(interfaceIndex);
        channelMonitoringInfoMap.put(info.getIndex(), info);
        return info;
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }
}

