/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.cablemodem.mserver.ChannelMonitoringInfo;
import com.dsoft.powerpro.cablemodem.mserver.ModemMonitoringData;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.modem.CMMonitor;
import com.dsoft.powerpro.monitorserver.devices.modem.ModemStatus;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMMonitoringThread
extends PoolTaskThread<DeviceOIDParameterPacket> {
    private static final Logger logger = Logger.getLogger(CMMonitoringThread.class.getName());
    private Integer monitorIteration;
    private ModemStatus modemStatus;

    public CMMonitoringThread(DeviceOIDParameterPacket packet, Integer monitorIteration, ModemStatus modemStatus) {
        super(packet, 420000L);
        this.monitorIteration = monitorIteration;
        this.modemStatus = modemStatus;
    }

    public static String constructThreadId(DeviceRequestPacket packet) {
        String id = "CM:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = id + packet.getQueueId();
        }
        return id;
    }

    @Override
    public void run() {
        try {
            logger.finer("Start modem monitoring for CM : " + this.modemStatus.getIp());
            DeviceOIDParameterPacket packet = (DeviceOIDParameterPacket)this.getPacket();
            CMMonitor cmMonitor = new CMMonitor(packet);
            ModemStatus modemStatus = cmMonitor.readMonitoringValues(this.modemStatus);
            if (modemStatus != null && packet.getDeviceId() != null) {
                modemStatus.onComplete(() -> {
                    logger.finer("Complete modem monitoring for CM : " + this.modemStatus.getIp());
                    ModemMonitoringData monitoringData = new ModemMonitoringData(modemStatus);
                    modemStatus.modemUpstreamInfoMap.values().forEach(ci -> {
                        Optional<ChannelMonitoringInfo> cmtsInfo = modemStatus.cmtsUpstreamInfoMap.values().stream().filter(cmtsci -> ci.getFrequency() == cmtsci.getFrequency()).findFirst();
                        cmtsInfo.ifPresent(cmtsci -> {
                            ci.setPowerLevel(cmtsci.getPowerLevel());
                            ci.setUncorrected(cmtsci.getUncorrected());
                            ci.setCorrected(cmtsci.getCorrected());
                            ci.setSnr(cmtsci.getSnr());
                            ci.setMicroReflections(cmtsci.getMicroReflections());
                            ci.setWidth(cmtsci.getWidth());
                        });
                    });
                    modemStatus.modemDownstreamInfoMap.values().forEach(ci -> {
                        Optional<ChannelMonitoringInfo> cmtsInfo = modemStatus.cmtsDownstreamInfoMap.values().stream().filter(cmtsci -> ci.getFrequency() == cmtsci.getFrequency()).findFirst();
                        cmtsInfo.ifPresent(cmtsci -> ci.setWidth(cmtsci.getWidth()));
                    });
                    monitoringData.setDownstreamMonitoringInfo(new ArrayList<ChannelMonitoringInfo>(modemStatus.modemDownstreamInfoMap.values()));
                    monitoringData.setUpstreamMonitoringInfo(new ArrayList<ChannelMonitoringInfo>(modemStatus.modemUpstreamInfoMap.values()));
                    monitoringData.setDocsis(modemStatus.getDocsis());
                    this.fillPacketAndSend(packet.getDeviceId(), modemStatus.getMac(), null, this.monitorIteration, monitoringData);
                }).complete();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    protected String getIdString() {
        return CMMonitoringThread.constructThreadId(this.getPacket());
    }
}

