/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.ServerProcessPingPacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.devices.BaseDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSMonitoringThread;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class CMTSDeviceMonitoring
extends BaseDeviceMonitoring {
    private static final Logger LOGGER = Logger.getLogger(CMTSDeviceMonitoring.class.getName());
    @Inject
    private MonitoringMessageProcessor msgProcessor;
    @Inject
    private SnmpPoolManager snmpPoolManager;

    @PostConstruct
    public void start() {
        this.msgProcessor.addListener("CmtsDto", this);
        try {
            List<DeviceDTO> devices = this.getMonitoringManager().getDevicesByType("CmtsDto");
            LOGGER.fine(String.format("There are %1$d CMTS devices to monitor", devices.size()));
            for (DeviceDTO dto : devices) {
                DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(dto.getId(), null, null);
                if (packet == null) continue;
                CMTSMonitoringThread thread = new CMTSMonitoringThread(packet, dto.getMonitorParamsTimeout() > 0L ? dto.getMonitorParamsTimeout() : 300000L, dto.getMonitorIteration(), this.snmpPoolManager);
                thread.setSnmpPoolManager(this.snmpPoolManager);
                this.snmpPoolManager.registerThread(thread, true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void changeCMTSMonitorThreadState(Integer deviceId, boolean started) {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(deviceId, null, null);
            if (packet == null) {
                return;
            }
            if (started) {
                LOGGER.fine(String.format("Starting CMTS monitoring thread for IP %1$s", packet.getIpAddress()));
                DeviceDTO dto = this.getMonitoringManager().getDevice(deviceId);
                CMTSMonitoringThread thread = new CMTSMonitoringThread(packet, dto.getMonitorParamsTimeout() > 0L ? dto.getMonitorParamsTimeout() : 300000L, dto.getMonitorIteration(), this.snmpPoolManager);
                this.snmpPoolManager.registerThread(thread, false);
            } else {
                LOGGER.fine(String.format("Stopping CMTS monitoring thread for IP %1$s", packet.getIpAddress()));
                this.snmpPoolManager.removeThread(CMTSMonitoringThread.constructThreadId(packet));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void processPacket(InfoPacket packet) {
        if (packet instanceof ServerProcessPingPacket) {
            ServerProcessPingPacket processPacket = (ServerProcessPingPacket)packet;
            this.changeCMTSMonitorThreadState(processPacket.getDeviceId(), processPacket.isMonitorDevSpecParams());
        } else {
            super.processPacket(packet);
        }
    }
}

